/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import java.nio.ByteBuffer;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenAbstractEntryReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkEntry;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkInput;

abstract class VarLenAbstractPageEntryReader
extends VarLenAbstractEntryReader {
    protected final VarLenColumnBulkInput.PageDataInfo pageInfo;
    protected final VarLenColumnBulkInput.ColumnPrecisionInfo columnPrecInfo;

    VarLenAbstractPageEntryReader(ByteBuffer _buffer, VarLenColumnBulkInput.PageDataInfo _pageInfo, VarLenColumnBulkInput.ColumnPrecisionInfo _columnPrecInfo, VarLenColumnBulkEntry _entry, VarLenColumnBulkInput.VarLenColumnBulkInputCallback _containerCallback) {
        super(_buffer, _entry, _containerCallback);
        this.pageInfo = _pageInfo;
        this.columnPrecInfo = _columnPrecInfo;
    }

    protected final boolean bulkProcess() {
        return this.columnPrecInfo.bulkProcess;
    }

    protected final boolean load(boolean force) {
        if (!force && this.buffer.hasRemaining()) {
            return true;
        }
        this.buffer.clear();
        int remaining = this.remainingPageData();
        int bufferCapacity = this.buffer.capacity() - 64;
        int toCopy = remaining > bufferCapacity ? bufferCapacity : remaining;
        this.buffer.limit(toCopy);
        if (toCopy == 0) {
            return false;
        }
        this.pageInfo.pageData.getBytes(this.pageInfo.pageDataOff, this.buffer.array(), this.buffer.position(), toCopy);
        return true;
    }

    protected final int remainingPageData() {
        return this.pageInfo.pageDataLen - this.pageInfo.pageDataOff;
    }

    protected final int getFixedLengthMaxRecordsToRead(int valuesToRead, int entrySz) {
        int numEntriesToRead = Math.min(this.entry.getMaxEntries(), valuesToRead);
        int bufferCapacity = this.buffer.capacity() - 64;
        numEntriesToRead = Math.min(numEntriesToRead, bufferCapacity / entrySz);
        return numEntriesToRead;
    }
}

