/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import java.nio.ByteBuffer;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenAbstractPageEntryReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkEntry;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkInput;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

final class VarLenFixedEntryReader
extends VarLenAbstractPageEntryReader {
    VarLenFixedEntryReader(ByteBuffer buffer, VarLenColumnBulkInput.PageDataInfo pageInfo, VarLenColumnBulkInput.ColumnPrecisionInfo columnPrecInfo, VarLenColumnBulkEntry entry, VarLenColumnBulkInput.VarLenColumnBulkInputCallback containerCallback) {
        super(buffer, pageInfo, columnPrecInfo, entry, containerCallback);
        Preconditions.checkArgument(columnPrecInfo.precision >= 0, "Fixed length precision [%s] cannot be lower than zero", columnPrecInfo.precision);
    }

    @Override
    final VarLenColumnBulkEntry getEntry(int valuesToRead) {
        int idx;
        this.load(true);
        int expectedDataLen = this.columnPrecInfo.precision;
        int entrySz = 4 + this.columnPrecInfo.precision;
        int readBatch = this.getFixedLengthMaxRecordsToRead(valuesToRead, entrySz);
        Preconditions.checkState(readBatch > 0, "Read batch count [%d] should be greater than zero", readBatch);
        int[] valueLengths = this.entry.getValuesLength();
        byte[] tgtBuff = this.entry.getInternalDataArray();
        byte[] srcBuff = this.buffer.array();
        for (idx = 0; idx < readBatch; ++idx) {
            int currPos = idx * entrySz;
            int dataLen = VarLenFixedEntryReader.getInt(srcBuff, currPos);
            if (dataLen != expectedDataLen) {
                return null;
            }
            valueLengths[idx] = dataLen;
            int tgt_pos = idx * expectedDataLen;
            if (expectedDataLen <= 0) continue;
            VarLenFixedEntryReader.vlCopy(srcBuff, currPos + 4, tgtBuff, tgt_pos, dataLen);
        }
        this.pageInfo.pageDataOff += idx * entrySz;
        this.entry.set(0, idx * expectedDataLen, idx, idx);
        return this.entry;
    }
}

