/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import java.nio.ByteBuffer;
import org.apache.drill.exec.store.parquet.columnreaders.PageReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenAbstractPageEntryReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkEntry;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkInput;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

final class VarLenNullableFixedEntryReader
extends VarLenAbstractPageEntryReader {
    VarLenNullableFixedEntryReader(ByteBuffer buffer, VarLenColumnBulkInput.PageDataInfo pageInfo, VarLenColumnBulkInput.ColumnPrecisionInfo columnPrecInfo, VarLenColumnBulkEntry entry, VarLenColumnBulkInput.VarLenColumnBulkInputCallback containerCallback) {
        super(buffer, pageInfo, columnPrecInfo, entry, containerCallback);
        Preconditions.checkArgument(columnPrecInfo.precision >= 0, "Fixed length precision cannot be lower than zero");
    }

    @Override
    VarLenColumnBulkEntry getEntry(int valuesToRead) {
        int idx;
        this.load(true);
        int expectedDataLen = this.columnPrecInfo.precision;
        int entrySz = 4 + this.columnPrecInfo.precision;
        int readBatch = this.getFixedLengthMaxRecordsToRead(valuesToRead, entrySz);
        Preconditions.checkState(readBatch > 0, "Read batch count [%s] should be greater than zero", readBatch);
        int[] valueLengths = this.entry.getValuesLength();
        byte[] tgtBuff = this.entry.getInternalDataArray();
        byte[] srcBuff = this.buffer.array();
        int nonNullValues = 0;
        PageReader.IntIterator definitionLevels = this.pageInfo.definitionLevels.getUnderlyingReader();
        for (idx = 0; idx < readBatch; ++idx) {
            if (definitionLevels.nextInt() == 1) {
                int currPos = nonNullValues * entrySz;
                int dataLen = VarLenNullableFixedEntryReader.getInt(srcBuff, currPos);
                if (dataLen != expectedDataLen) {
                    return null;
                }
                valueLengths[idx] = dataLen;
                int tgt_pos = nonNullValues * expectedDataLen;
                if (expectedDataLen > 0) {
                    VarLenNullableFixedEntryReader.vlCopy(srcBuff, currPos + 4, tgtBuff, tgt_pos, dataLen);
                }
                ++nonNullValues;
                continue;
            }
            valueLengths[idx] = -1;
        }
        this.pageInfo.pageDataOff += nonNullValues * entrySz;
        this.entry.set(0, nonNullValues * expectedDataLen, idx, nonNullValues);
        return this.entry;
    }
}

