/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import java.io.IOException;
import java.util.Collections;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.store.parquet.columnreaders.ColumnReader;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetRecordReader;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.io.api.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VarLengthColumn<V extends ValueVector>
extends ColumnReader<V> {
    static final Logger logger = LoggerFactory.getLogger(VarLengthColumn.class);
    Binary currDictVal;

    VarLengthColumn(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, V v, SchemaElement schemaElement) throws ExecutionSetupException {
        super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        this.usingDictionary = !Collections.disjoint(columnChunkMetaData.getEncodings(), ColumnReader.DICTIONARY_ENCODINGS);
    }

    @Override
    protected boolean processPageData(int recordsToReadInThisPass) throws IOException {
        return this.readAndStoreValueSizeInformation();
    }

    @Override
    public void reset() {
        super.reset();
        this.pageReader.valuesReadyToRead = 0;
    }

    protected abstract boolean readAndStoreValueSizeInformation() throws IOException;

    public abstract boolean skipReadyToReadPositionUpdate();
}

