/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.util.Collections;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.store.parquet.columnreaders.ColumnReader;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetRecordReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkInput;
import org.apache.drill.exec.store.parquet.columnreaders.VarLengthColumn;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarLenBulkEntry;
import org.apache.drill.exec.vector.VarLenBulkInput;
import org.apache.drill.exec.vector.VariableWidthVector;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.io.api.Binary;

public abstract class VarLengthValuesColumn<V extends ValueVector>
extends VarLengthColumn {
    Binary currLengthDeterminingDictVal;
    Binary currDecodedValToWrite;
    VariableWidthVector variableWidthVector;
    protected final VarLenColumnBulkInput.BulkReaderState bulkReaderState = new VarLenColumnBulkInput.BulkReaderState();

    VarLengthValuesColumn(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, V v, SchemaElement schemaElement) throws ExecutionSetupException {
        super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        this.variableWidthVector = (VariableWidthVector)this.valueVec;
        if (!Collections.disjoint(columnChunkMetaData.getEncodings(), ColumnReader.DICTIONARY_ENCODINGS)) {
            this.usingDictionary = true;
            this.bulkReaderState.columnPrecInfo.columnPrecisionType = VarLenColumnBulkInput.ColumnPrecisionType.DT_PRECISION_IS_VARIABLE;
            this.bulkReaderState.columnPrecInfo.bulkProcess = true;
        } else {
            this.usingDictionary = false;
        }
    }

    public abstract boolean setSafe(int var1, DrillBuf var2, int var3, int var4);

    protected abstract void setSafe(VarLenBulkInput<VarLenBulkEntry> var1);

    protected abstract VarLenColumnBulkInput<V> newVLBulkInput(int var1) throws IOException;

    @Override
    protected final int readRecordsInBulk(int recordsToRead) throws IOException {
        VarLenColumnBulkInput<V> bulkInput = this.newVLBulkInput(recordsToRead);
        this.setSafe(bulkInput);
        this.valuesReadInCurrentPass = bulkInput.getReadBatchFields();
        return this.valuesReadInCurrentPass;
    }

    @Override
    protected void readField(long recordToRead) {
        this.dataTypeLengthInBits = this.variableWidthVector.getAccessor().getValueLength(this.valuesReadInCurrentPass);
        boolean success = this.setSafe(this.valuesReadInCurrentPass, this.pageReader.pageData, (int)this.pageReader.readPosInBytes + 4, this.dataTypeLengthInBits);
        assert (success);
        this.updatePosition();
    }

    @Override
    public void updateReadyToReadPosition() {
        this.pageReader.readyToReadPosInBytes += (long)(this.dataTypeLengthInBits + 4);
        ++this.pageReader.valuesReadyToRead;
        this.currLengthDeterminingDictVal = null;
    }

    @Override
    public void updatePosition() {
        this.pageReader.readPosInBytes += (long)(this.dataTypeLengthInBits + 4);
        this.bytesReadInCurrentPass += this.dataTypeLengthInBits;
        ++this.valuesReadInCurrentPass;
    }

    @Override
    public boolean skipReadyToReadPositionUpdate() {
        return false;
    }

    @Override
    protected boolean readAndStoreValueSizeInformation() throws IOException {
        if (this.usingDictionary) {
            if (this.currLengthDeterminingDictVal == null) {
                this.currLengthDeterminingDictVal = this.pageReader.getDictionaryLengthDeterminingReader().readBytes();
            }
            this.currDecodedValToWrite = this.currLengthDeterminingDictVal;
            this.dataTypeLengthInBits = this.currLengthDeterminingDictVal.length();
        } else {
            this.dataTypeLengthInBits = this.pageReader.pageData.getInt((int)this.pageReader.readyToReadPosInBytes);
        }
        this.variableWidthVector.getMutator().setValueLengthSafe(this.valuesReadInCurrentPass + this.pageReader.valuesReadyToRead, this.dataTypeLengthInBits);
        return false;
    }
}

