/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders.batchsizing;

import java.util.List;
import java.util.Map;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetColumnMetadata;
import org.apache.drill.exec.store.parquet.columnreaders.batchsizing.BatchSizingMemoryUtil;
import org.apache.drill.exec.store.parquet.columnreaders.batchsizing.RecordBatchSizerManager;

final class BatchOverflowOptimizer {
    private static final int MAX_NUM_OVERFLOWS = 3;
    private final Map<String, RecordBatchSizerManager.ColumnMemoryInfo> columnMemoryInfoMap;
    private final Map<String, ColumnPrecisionStats> columnStatsMap = CaseInsensitiveMap.newHashMap();
    private int numBatches;
    private int numOverflows;
    boolean columnPrecisionChanged;

    BatchOverflowOptimizer(Map<String, RecordBatchSizerManager.ColumnMemoryInfo> columnMemoryInfoMap) {
        this.columnMemoryInfoMap = columnMemoryInfoMap;
    }

    void setup() {
        for (RecordBatchSizerManager.ColumnMemoryInfo columnInfo : this.columnMemoryInfoMap.values()) {
            ParquetColumnMetadata columnMeta = columnInfo.columnMeta;
            if (columnMeta.isFixedLength()) continue;
            this.columnStatsMap.put(columnMeta.getField().getName(), new ColumnPrecisionStats(columnMeta.getField()));
        }
    }

    boolean onEndOfBatch(int batchNumRecords, List<RecordBatchSizerManager.VarLenColumnBatchStats> batchStats) {
        if (batchNumRecords == 0) {
            return false;
        }
        ++this.numBatches;
        boolean overflow = false;
        BatchSizingMemoryUtil.VectorMemoryUsageInfo vectorMemoryUsage = new BatchSizingMemoryUtil.VectorMemoryUsageInfo();
        for (RecordBatchSizerManager.VarLenColumnBatchStats stat : batchStats) {
            String columnName = stat.vector.getField().getName();
            ColumnPrecisionStats columnPrecisionStats = this.columnStatsMap.get(columnName);
            assert (columnPrecisionStats != null);
            if (stat.numValuesRead > batchNumRecords) {
                overflow = true;
            }
            BatchSizingMemoryUtil.getMemoryUsage(stat.vector, stat.numValuesRead, vectorMemoryUsage);
            long batchColumnPrecision = Math.max(1L, vectorMemoryUsage.dataBytesUsed / (long)stat.numValuesRead);
            double currAvgPrecision = columnPrecisionStats.avgPrecision;
            double newAvgPrecision = ((double)(this.numBatches - 1) * currAvgPrecision + (double)batchColumnPrecision) / (double)this.numBatches;
            if (!(newAvgPrecision > currAvgPrecision)) continue;
            columnPrecisionStats.avgPrecision = (int)Math.ceil(newAvgPrecision);
            this.columnPrecisionChanged = true;
        }
        if (overflow) {
            ++this.numOverflows;
        }
        if (this.numBatches == 1 || this.columnPrecisionChanged && this.numOverflows >= 3) {
            for (ColumnPrecisionStats columnPrecisionStats : this.columnStatsMap.values()) {
                RecordBatchSizerManager.ColumnMemoryInfo columnInfo = this.columnMemoryInfoMap.get(columnPrecisionStats.field.getName());
                assert (columnInfo != null);
                columnInfo.columnPrecision = columnPrecisionStats.avgPrecision;
                columnInfo.columnMemoryQuota.reset();
            }
            this.numOverflows = 0;
            this.columnPrecisionChanged = false;
            return true;
        }
        return false;
    }

    private static final class ColumnPrecisionStats {
        private final MaterializedField field;
        private long avgPrecision;

        private ColumnPrecisionStats(MaterializedField field) {
            this.field = field;
        }
    }
}

