/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders.batchsizing;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.memory.BaseAllocator;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetColumnMetadata;
import org.apache.drill.exec.store.parquet.columnreaders.batchsizing.RecordBatchSizerManager;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.NullableVarDecimalVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarBinaryVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.apache.drill.exec.vector.VarDecimalVector;
import org.apache.drill.exec.vector.VariableWidthVector;

public final class BatchSizingMemoryUtil {
    public static final int BYTE_VALUE_WIDTH = 1;
    public static final int INT_VALUE_WIDTH = 4;
    public static final int DEFAULT_VL_COLUMN_AVG_PRECISION = 16;

    public static boolean canAddNewData(ColumnMemoryUsageInfo columnMemoryUsage, long newBitsMemory, long newOffsetsMemory, long newDataMemory) {
        VectorMemoryUsageInfo vectorMemoryUsage = columnMemoryUsage.vectorMemoryUsage;
        BatchSizingMemoryUtil.getMemoryUsage(columnMemoryUsage.vector, columnMemoryUsage.currValueCount, vectorMemoryUsage);
        long totalBitsMemory = BatchSizingMemoryUtil.computeNewVectorCapacity(vectorMemoryUsage.bitsBytesUsed, newBitsMemory, vectorMemoryUsage.bitsBytesCapacity);
        long totalOffsetsMemory = BatchSizingMemoryUtil.computeNewVectorCapacity(vectorMemoryUsage.offsetsBytesUsed, newOffsetsMemory, vectorMemoryUsage.offsetsByteCapacity);
        long totalDataMemory = BatchSizingMemoryUtil.computeNewVectorCapacity(vectorMemoryUsage.dataBytesUsed, newDataMemory, vectorMemoryUsage.dataByteCapacity);
        long totalMemory = totalBitsMemory + totalOffsetsMemory + totalDataMemory;
        assert (totalMemory >= 0L);
        return totalMemory <= columnMemoryUsage.memoryQuota.getMaxMemoryUsage();
    }

    public static void getMemoryUsage(ValueVector sourceVector, int currValueCount, VectorMemoryUsageInfo vectorMemoryUsage) {
        assert (sourceVector instanceof VariableWidthVector);
        vectorMemoryUsage.reset();
        TypeProtos.MajorType type = sourceVector.getField().getType();
        block0 : switch (type.getMinorType()) {
            case VARCHAR: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        VarCharVector vector = (VarCharVector)sourceVector;
                        vectorMemoryUsage.offsetsByteCapacity = vector.getOffsetVector().getValueCapacity() * 4;
                        vectorMemoryUsage.dataByteCapacity = vector.getByteCapacity();
                        vectorMemoryUsage.offsetsBytesUsed = vector.getOffsetVector().getPayloadByteCount(currValueCount);
                        vectorMemoryUsage.dataBytesUsed = (long)vector.getPayloadByteCount(currValueCount) - vectorMemoryUsage.offsetsBytesUsed;
                        break block0;
                    }
                    case OPTIONAL: {
                        NullableVarCharVector vector = (NullableVarCharVector)sourceVector;
                        VarCharVector values = vector.getValuesVector();
                        vectorMemoryUsage.bitsBytesCapacity = vector.getBitsValueCapacity();
                        vectorMemoryUsage.offsetsByteCapacity = values.getOffsetVector().getValueCapacity() * 4;
                        vectorMemoryUsage.dataByteCapacity = values.getByteCapacity();
                        vectorMemoryUsage.bitsBytesUsed = currValueCount * 1;
                        vectorMemoryUsage.offsetsBytesUsed = values.getOffsetVector().getPayloadByteCount(currValueCount);
                        vectorMemoryUsage.dataBytesUsed = (long)values.getPayloadByteCount(currValueCount) - vectorMemoryUsage.offsetsBytesUsed;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Mode [" + type.getMode().name() + "] not supported..");
            }
            case VARBINARY: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        VarBinaryVector vector = (VarBinaryVector)sourceVector;
                        vectorMemoryUsage.offsetsByteCapacity = vector.getOffsetVector().getValueCapacity() * 4;
                        vectorMemoryUsage.dataByteCapacity = vector.getByteCapacity();
                        vectorMemoryUsage.offsetsBytesUsed = vector.getOffsetVector().getPayloadByteCount(currValueCount);
                        vectorMemoryUsage.dataBytesUsed = (long)vector.getPayloadByteCount(currValueCount) - vectorMemoryUsage.offsetsBytesUsed;
                        break block0;
                    }
                    case OPTIONAL: {
                        NullableVarBinaryVector vector = (NullableVarBinaryVector)sourceVector;
                        VarBinaryVector values = vector.getValuesVector();
                        vectorMemoryUsage.bitsBytesCapacity = vector.getBitsValueCapacity();
                        vectorMemoryUsage.offsetsByteCapacity = values.getOffsetVector().getValueCapacity() * 4;
                        vectorMemoryUsage.dataByteCapacity = values.getByteCapacity();
                        vectorMemoryUsage.bitsBytesUsed = currValueCount * 1;
                        vectorMemoryUsage.offsetsBytesUsed = values.getOffsetVector().getPayloadByteCount(currValueCount);
                        vectorMemoryUsage.dataBytesUsed = (long)values.getPayloadByteCount(currValueCount) - vectorMemoryUsage.offsetsBytesUsed;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Mode [" + type.getMode().name() + "] not supported..");
            }
            case VARDECIMAL: {
                switch (type.getMode()) {
                    case REQUIRED: {
                        VarDecimalVector vector = (VarDecimalVector)sourceVector;
                        vectorMemoryUsage.offsetsByteCapacity = vector.getOffsetVector().getValueCapacity() * 4;
                        vectorMemoryUsage.dataByteCapacity = vector.getByteCapacity();
                        vectorMemoryUsage.offsetsBytesUsed = vector.getOffsetVector().getPayloadByteCount(currValueCount);
                        vectorMemoryUsage.dataBytesUsed = (long)vector.getPayloadByteCount(currValueCount) - vectorMemoryUsage.offsetsBytesUsed;
                        break block0;
                    }
                    case OPTIONAL: {
                        NullableVarDecimalVector vector = (NullableVarDecimalVector)sourceVector;
                        VarDecimalVector values = vector.getValuesVector();
                        vectorMemoryUsage.bitsBytesCapacity = vector.getBitsValueCapacity();
                        vectorMemoryUsage.offsetsByteCapacity = values.getOffsetVector().getValueCapacity() * 4;
                        vectorMemoryUsage.dataByteCapacity = values.getByteCapacity();
                        vectorMemoryUsage.bitsBytesUsed = currValueCount * 1;
                        vectorMemoryUsage.offsetsBytesUsed = values.getOffsetVector().getPayloadByteCount(currValueCount);
                        vectorMemoryUsage.dataBytesUsed = (long)values.getPayloadByteCount(currValueCount) - vectorMemoryUsage.offsetsBytesUsed;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Mode [" + type.getMode().name() + "] not supported..");
            }
            default: {
                throw new IllegalArgumentException("Type [" + type.getMinorType().name() + "] not supported..");
            }
        }
        assert (vectorMemoryUsage.bitsBytesCapacity >= 0L);
        assert (vectorMemoryUsage.bitsBytesUsed >= 0L);
        assert (vectorMemoryUsage.offsetsByteCapacity >= 0L);
        assert (vectorMemoryUsage.offsetsBytesUsed >= 0L);
        assert (vectorMemoryUsage.dataByteCapacity >= 0L);
        assert (vectorMemoryUsage.dataBytesUsed >= 0L);
    }

    public static int getFixedColumnTypePrecision(ParquetColumnMetadata column) {
        assert (column.isFixedLength());
        return TypeHelper.getSize(column.getField().getType());
    }

    public static int getAvgVariableLengthColumnTypePrecision(ParquetColumnMetadata column) {
        assert (!column.isFixedLength());
        return 16;
    }

    public static long computeFixedLengthVectorMemory(ParquetColumnMetadata column, int valueCount) {
        assert (column.isFixedLength());
        long memoryUsage = BaseAllocator.longNextPowerOfTwo(BatchSizingMemoryUtil.getFixedColumnTypePrecision(column) * valueCount);
        if (column.getField().isNullable()) {
            memoryUsage += BaseAllocator.longNextPowerOfTwo(1 * valueCount);
        }
        return memoryUsage;
    }

    public static long computeVariableLengthVectorMemory(ParquetColumnMetadata column, long averagePrecision, int valueCount) {
        assert (!column.isFixedLength());
        long memoryUsage = BaseAllocator.longNextPowerOfTwo(averagePrecision * (long)valueCount);
        memoryUsage += BaseAllocator.longNextPowerOfTwo(4 * (valueCount + 1));
        if (column.getField().isNullable()) {
            memoryUsage += BaseAllocator.longNextPowerOfTwo(valueCount);
        }
        return memoryUsage;
    }

    private static long computeNewVectorCapacity(long usedCapacity, long newPayload, long currentCapacity) {
        long newUsedCapacity = BaseAllocator.longNextPowerOfTwo(usedCapacity + newPayload);
        assert (newUsedCapacity >= 0L);
        return Math.max(currentCapacity, newUsedCapacity);
    }

    private BatchSizingMemoryUtil() {
    }

    public static final class ColumnMemoryUsageInfo {
        public ValueVector vector;
        public RecordBatchSizerManager.ColumnMemoryQuota memoryQuota;
        public int currValueCount;
        public final VectorMemoryUsageInfo vectorMemoryUsage = new VectorMemoryUsageInfo();
    }

    public static final class VectorMemoryUsageInfo {
        public long bitsBytesCapacity;
        public long offsetsByteCapacity;
        public long dataByteCapacity;
        public long bitsBytesUsed;
        public long offsetsBytesUsed;
        public long dataBytesUsed;

        public void reset() {
            this.bitsBytesCapacity = 0L;
            this.offsetsByteCapacity = 0L;
            this.dataByteCapacity = 0L;
            this.bitsBytesUsed = 0L;
            this.offsetsBytesUsed = 0L;
            this.dataBytesUsed = 0L;
        }
    }
}

