/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders.batchsizing;

import io.netty.buffer.DrillBuf;
import java.util.List;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.store.parquet.columnreaders.batchsizing.RecordBatchOverflow;
import org.apache.drill.exec.util.record.RecordBatchStats;

final class OverflowSerDeUtil {
    static RecordBatchOverflow.RecordOverflowContainer serialize(List<RecordBatchOverflow.FieldOverflowEntry> fieldOverflowEntries, BufferAllocator allocator, RecordBatchStats.RecordBatchStatsContext batchStatsContext) {
        if (fieldOverflowEntries == null || fieldOverflowEntries.isEmpty()) {
            return null;
        }
        CaseInsensitiveMap fieldSerDeMap = CaseInsensitiveMap.newHashMap();
        int bufferLength = 0;
        for (RecordBatchOverflow.FieldOverflowEntry fieldOverflowEntry : fieldOverflowEntries) {
            VLVectorSerializer fieldVLSerDe = new VLVectorSerializer(fieldOverflowEntry);
            fieldSerDeMap.put(fieldOverflowEntry.vector.getField().getName(), fieldVLSerDe);
            bufferLength += fieldVLSerDe.getBytesUsed(fieldOverflowEntry.firstValueIdx, fieldOverflowEntry.numValues);
        }
        assert (bufferLength >= 0);
        DrillBuf buffer = allocator.buffer(bufferLength);
        RecordBatchStats.logRecordBatchStats(batchStatsContext, "Allocated a buffer of length [%d] to handle overflow", bufferLength);
        RecordBatchOverflow.RecordOverflowContainer recordOverflowContainer = new RecordBatchOverflow.RecordOverflowContainer();
        RecordBatchOverflow.RecordOverflowDefinition recordOverflowDef = recordOverflowContainer.recordOverflowDef;
        int bufferOffset = 0;
        FieldSerializerContainer fieldSerializerContainer = new FieldSerializerContainer();
        for (RecordBatchOverflow.FieldOverflowEntry fieldOverflowEntry : fieldOverflowEntries) {
            fieldSerializerContainer.clear();
            VLVectorSerializer fieldSerDe = (VLVectorSerializer)fieldSerDeMap.get(fieldOverflowEntry.vector.getField().getName());
            assert (fieldSerDe != null);
            fieldSerDe.copyValueVector(fieldOverflowEntry.firstValueIdx, fieldOverflowEntry.numValues, buffer, bufferOffset, fieldSerializerContainer);
            DrillBuf fieldBuffer = buffer.slice(bufferOffset, fieldSerializerContainer.totalByteLength);
            fieldBuffer.retain(1);
            fieldBuffer.writerIndex(fieldSerializerContainer.totalByteLength);
            RecordBatchOverflow.FieldOverflowDefinition fieldOverflowDef = new RecordBatchOverflow.FieldOverflowDefinition(fieldOverflowEntry.vector.getField(), fieldOverflowEntry.numValues, fieldSerializerContainer.dataByteLen, fieldBuffer);
            recordOverflowDef.getFieldOverflowDefs().put(fieldOverflowEntry.vector.getField().getName(), fieldOverflowDef);
            bufferOffset += fieldSerializerContainer.totalByteLength;
        }
        boolean isReleased = buffer.release();
        assert (!isReleased);
        return recordOverflowContainer;
    }

    private OverflowSerDeUtil() {
    }

    private static final class VLVectorSerializer {
        private static final int BYTE_VALUE_WIDTH = 1;
        private static final int INT_VALUE_WIDTH = 4;
        private final RecordBatchOverflow.FieldOverflowEntry fieldOverflowEntry;
        private final DrillBuf[] buffers;

        private VLVectorSerializer(RecordBatchOverflow.FieldOverflowEntry fieldOverflowEntry) {
            this.fieldOverflowEntry = fieldOverflowEntry;
            this.buffers = this.fieldOverflowEntry.vector.getBuffers(false);
        }

        private int getBytesUsed(int firstValueIdx, int numValues) {
            int bytesUsed = 0;
            if (this.isNullable()) {
                bytesUsed += numValues * 1;
            }
            bytesUsed += (numValues + 1) * 4;
            return bytesUsed += this.getDataLen(firstValueIdx, numValues);
        }

        private void copyValueVector(int firstValueIdx, int numValues, DrillBuf targetBuffer, int targetStartIdx, FieldSerializerContainer fieldSerializerContainer) {
            int len = 0;
            int totalLen = 0;
            len = this.copyBitsVector(firstValueIdx, numValues, targetBuffer, targetStartIdx);
            assert (len >= 0);
            totalLen += len;
            len = this.copyOffsetVector(firstValueIdx, numValues, targetBuffer, targetStartIdx + totalLen);
            assert (len >= 0);
            totalLen += len;
            len = this.copyValuesVector(firstValueIdx, numValues, targetBuffer, targetStartIdx + totalLen);
            assert (len >= 0);
            fieldSerializerContainer.dataByteLen = len;
            fieldSerializerContainer.totalByteLength = totalLen + len;
        }

        private int copyBitsVector(int firstValueIdx, int numValues, DrillBuf targetBuffer, int targetStartIdx) {
            int bytesCopied = 0;
            if (!this.isNullable()) {
                return bytesCopied;
            }
            DrillBuf srcBuffer = this.getBitsBuffer();
            assert (srcBuffer != null);
            bytesCopied = numValues * 1;
            srcBuffer.getBytes(firstValueIdx * 1, targetBuffer, targetStartIdx, bytesCopied);
            return bytesCopied;
        }

        private int copyOffsetVector(int firstValueIdx, int numValues, DrillBuf targetBuffer, int targetStartIdx) {
            int bytesCopied = (numValues + 1) * 4;
            DrillBuf srcBuffer = this.getOffsetsBuffer();
            assert (srcBuffer != null);
            srcBuffer.getBytes(firstValueIdx * 4, targetBuffer, targetStartIdx, bytesCopied);
            return bytesCopied;
        }

        private int copyValuesVector(int firstValueIdx, int numValues, DrillBuf targetBuffer, int targetStartIdx) {
            DrillBuf offsets = this.getOffsetsBuffer();
            int startDataOffset = offsets.getInt(firstValueIdx * 4);
            int bytesCopied = this.getDataLen(firstValueIdx, numValues);
            DrillBuf srcBuffer = this.getValuesBuffer();
            assert (srcBuffer != null);
            srcBuffer.getBytes(startDataOffset, targetBuffer, targetStartIdx, bytesCopied);
            return bytesCopied;
        }

        private int getDataLen(int firstValueIdx, int numValues) {
            DrillBuf offsets = this.getOffsetsBuffer();
            int endDataOffset = offsets.getInt((firstValueIdx + numValues) * 4);
            int startDataOffset = offsets.getInt(firstValueIdx * 4);
            return endDataOffset - startDataOffset;
        }

        private DrillBuf getBitsBuffer() {
            return this.buffers.length == 3 ? this.buffers[0] : null;
        }

        private DrillBuf getOffsetsBuffer() {
            return this.buffers.length == 3 ? this.buffers[1] : this.buffers[0];
        }

        private DrillBuf getValuesBuffer() {
            return this.buffers.length == 3 ? this.buffers[2] : this.buffers[1];
        }

        private boolean isNullable() {
            return this.getBitsBuffer() != null;
        }
    }

    private static final class FieldSerializerContainer {
        int dataByteLen;
        int totalByteLength;

        private FieldSerializerContainer() {
        }

        void clear() {
            this.dataByteLen = 0;
            this.totalByteLength = 0;
        }
    }
}

