/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders.batchsizing;

import io.netty.buffer.DrillBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.store.parquet.columnreaders.batchsizing.OverflowSerDeUtil;
import org.apache.drill.exec.util.record.RecordBatchStats;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VariableWidthVector;

public final class RecordBatchOverflow {
    final RecordOverflowDefinition recordOverflowDef;
    final BufferAllocator allocator;

    public static Builder newBuilder(BufferAllocator allocator, RecordBatchStats.RecordBatchStatsContext batchStatsContext) {
        return new Builder(allocator, batchStatsContext);
    }

    public RecordOverflowDefinition getRecordOverflowDefinition() {
        return this.recordOverflowDef;
    }

    private RecordBatchOverflow(RecordOverflowDefinition recordOverflowDef, BufferAllocator allocator) {
        this.recordOverflowDef = recordOverflowDef;
        this.allocator = allocator;
    }

    public static final class RecordOverflowDefinition {
        private final Map<String, FieldOverflowDefinition> fieldOverflowDefs = CaseInsensitiveMap.newHashMap();

        public Map<String, FieldOverflowDefinition> getFieldOverflowDefs() {
            return this.fieldOverflowDefs;
        }
    }

    public static final class Builder {
        private final List<FieldOverflowEntry> fieldOverflowEntries = new ArrayList<FieldOverflowEntry>();
        private final BufferAllocator allocator;
        private final RecordBatchStats.RecordBatchStatsContext batchStatsContext;

        private Builder(BufferAllocator allocator, RecordBatchStats.RecordBatchStatsContext batchStatsContext) {
            this.allocator = allocator;
            this.batchStatsContext = batchStatsContext;
        }

        public void addFieldOverflow(ValueVector vector, int firstValueIdx, int numValues) {
            assert (vector instanceof VariableWidthVector);
            this.fieldOverflowEntries.add(new FieldOverflowEntry(vector, firstValueIdx, numValues));
        }

        public RecordBatchOverflow build() {
            RecordOverflowContainer overflowContainer = OverflowSerDeUtil.serialize(this.fieldOverflowEntries, this.allocator, this.batchStatsContext);
            RecordBatchOverflow result = new RecordBatchOverflow(overflowContainer.recordOverflowDef, this.allocator);
            return result;
        }
    }

    static final class RecordOverflowContainer {
        final RecordOverflowDefinition recordOverflowDef = new RecordOverflowDefinition();

        RecordOverflowContainer() {
        }
    }

    public static final class FieldOverflowDefinition {
        public final MaterializedField field;
        public final int numValues;
        public final int dataByteLen;
        public final DrillBuf buffer;

        FieldOverflowDefinition(MaterializedField field, int numValues, int dataByteLen, DrillBuf buffer) {
            this.field = field;
            this.numValues = numValues;
            this.dataByteLen = dataByteLen;
            this.buffer = buffer;
        }
    }

    static final class FieldOverflowEntry {
        final ValueVector vector;
        final int firstValueIdx;
        final int numValues;

        private FieldOverflowEntry(ValueVector vector, int firstValueIdx, int numValues) {
            this.vector = vector;
            this.firstValueIdx = firstValueIdx;
            this.numValues = numValues;
        }
    }
}

