/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.compression;

import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.lz4.Lz4Compressor;
import io.airlift.compress.lz4.Lz4Decompressor;
import io.airlift.compress.lzo.LzoCompressor;
import io.airlift.compress.lzo.LzoDecompressor;
import io.airlift.compress.snappy.SnappyCompressor;
import io.airlift.compress.snappy.SnappyDecompressor;
import io.airlift.compress.zstd.ZstdCompressor;
import io.airlift.compress.zstd.ZstdDecompressor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.LinkedList;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirliftBytesInputCompressor
implements CompressionCodecFactory.BytesInputCompressor,
CompressionCodecFactory.BytesInputDecompressor {
    private static final Logger logger = LoggerFactory.getLogger(AirliftBytesInputCompressor.class);
    private CompressionCodecName codecName;
    private Compressor airComp;
    private Decompressor airDecomp;
    private ByteBufferAllocator allocator;
    private Deque<ByteBuffer> allocatedBuffers;

    public AirliftBytesInputCompressor(CompressionCodecName codecName, ByteBufferAllocator allocator) {
        this.codecName = codecName;
        switch (codecName) {
            case LZ4: {
                this.airComp = new Lz4Compressor();
                this.airDecomp = new Lz4Decompressor();
                break;
            }
            case LZO: {
                this.airComp = new LzoCompressor();
                this.airDecomp = new LzoDecompressor();
                break;
            }
            case SNAPPY: {
                this.airComp = new SnappyCompressor();
                this.airDecomp = new SnappyDecompressor();
                break;
            }
            case ZSTD: {
                this.airComp = new ZstdCompressor();
                this.airDecomp = new ZstdDecompressor();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Parquet compression codec is not supported: " + codecName);
            }
        }
        this.allocator = allocator;
        this.allocatedBuffers = new LinkedList<ByteBuffer>();
        logger.debug("constructed a {} using a backing compressor of {}", (Object)this.getClass().getName(), (Object)this.airComp.getClass().getName());
    }

    public BytesInput compress(BytesInput bytes) throws IOException {
        ByteBuffer inBuf = bytes.toByteBuffer();
        logger.trace("will use aircompressor to compress {} bytes from a {} containing a {}", new Object[]{bytes.size(), bytes.getClass().getName(), inBuf.getClass().getName()});
        int maxOutLen = this.airComp.maxCompressedLength((int)bytes.size());
        ByteBuffer outBuf = this.allocator.allocate(maxOutLen);
        this.allocatedBuffers.push(outBuf);
        this.airComp.compress(inBuf, outBuf);
        return BytesInput.from((ByteBuffer[])new ByteBuffer[]{(ByteBuffer)outBuf.flip()});
    }

    public CompressionCodecName getCodecName() {
        return this.codecName;
    }

    public BytesInput decompress(BytesInput bytes, int uncompressedSize) throws IOException {
        ByteBuffer inBuf = bytes.toByteBuffer();
        logger.trace("will use aircompressor to decompress {} bytes from a {} containing a {}.", new Object[]{uncompressedSize, bytes.getClass().getName(), inBuf.getClass().getName()});
        ByteBuffer outBuf = this.allocator.allocate(uncompressedSize);
        this.allocatedBuffers.push(outBuf);
        this.airDecomp.decompress(inBuf, outBuf);
        return BytesInput.from((ByteBuffer[])new ByteBuffer[]{(ByteBuffer)outBuf.flip()});
    }

    public void decompress(ByteBuffer input, int compressedSize, ByteBuffer output, int uncompressedSize) throws IOException {
        logger.trace("will use aircompressor to decompress {} bytes from a {} to a {}.", new Object[]{uncompressedSize, input.getClass().getName(), output.getClass().getName()});
        this.airDecomp.decompress(input, output);
    }

    public void release() {
        int bufCount = this.allocatedBuffers.size();
        int i = 0;
        while (!this.allocatedBuffers.isEmpty()) {
            this.allocator.release(this.allocatedBuffers.pop());
            ++i;
        }
        assert (bufCount == i);
        logger.debug("released {} allocated buffers", (Object)bufCount);
    }
}

