/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.ParquetReaderUtility;
import org.apache.drill.exec.store.parquet.metadata.Metadata;
import org.apache.drill.exec.store.parquet.metadata.Metadata_V4;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMetadataCollector {
    private static final Logger logger = LoggerFactory.getLogger(FileMetadataCollector.class);
    private final ParquetMetadata metadata;
    private final FileStatus file;
    private final FileSystem fs;
    private final boolean allColumnsInteresting;
    private final boolean skipNonInteresting;
    private final Set<SchemaPath> columnSet;
    private final MessageType schema;
    private final ParquetReaderUtility.DateCorruptionStatus containsCorruptDates;
    private final Map<SchemaPath, ColTypeInfo> colTypeInfoMap;
    private final Map<Metadata_V4.ColumnTypeMetadata_v4.Key, Long> totalNullCountMap = new HashMap<Metadata_V4.ColumnTypeMetadata_v4.Key, Long>();
    private final Map<Metadata_V4.ColumnTypeMetadata_v4.Key, Metadata_V4.ColumnTypeMetadata_v4> columnTypeInfo = new HashMap<Metadata_V4.ColumnTypeMetadata_v4.Key, Metadata_V4.ColumnTypeMetadata_v4>();
    private Metadata_V4.ParquetFileAndRowCountMetadata fileMetadata;

    public FileMetadataCollector(ParquetMetadata metadata, FileStatus file, FileSystem fs, boolean allColumnsInteresting, boolean skipNonInteresting, Set<SchemaPath> columnSet, ParquetReaderConfig readerConfig) throws IOException {
        this.metadata = metadata;
        this.file = file;
        this.fs = fs;
        this.allColumnsInteresting = allColumnsInteresting;
        this.skipNonInteresting = skipNonInteresting;
        this.columnSet = columnSet;
        this.schema = metadata.getFileMetaData().getSchema();
        this.containsCorruptDates = ParquetReaderUtility.detectCorruptDates(metadata, Collections.singletonList(SchemaPath.STAR_COLUMN), readerConfig.autoCorrectCorruptedDates());
        logger.debug("Contains corrupt dates: {}.", (Object)this.containsCorruptDates);
        this.colTypeInfoMap = new HashMap<SchemaPath, ColTypeInfo>();
        for (String[] path : this.schema.getPaths()) {
            this.colTypeInfoMap.put(SchemaPath.getCompoundPath(path), ColTypeInfo.of(this.schema, (Type)this.schema, path, 0, new ArrayList<OriginalType>()));
        }
        this.init();
    }

    public Metadata_V4.ParquetFileAndRowCountMetadata getFileMetadata() {
        return this.fileMetadata;
    }

    public Map<Metadata_V4.ColumnTypeMetadata_v4.Key, Metadata_V4.ColumnTypeMetadata_v4> getColumnTypeInfo() {
        return this.columnTypeInfo;
    }

    private void init() throws IOException {
        long totalRowCount = 0L;
        ArrayList<Metadata_V4.RowGroupMetadata_v4> rowGroupMetadataList = new ArrayList<Metadata_V4.RowGroupMetadata_v4>();
        for (Object rowGroup : this.metadata.getBlocks()) {
            ArrayList<Metadata_V4.ColumnMetadata_v4> columnMetadataList = new ArrayList<Metadata_V4.ColumnMetadata_v4>();
            long length = 0L;
            totalRowCount += rowGroup.getRowCount();
            for (ColumnChunkMetaData col : rowGroup.getColumns()) {
                String[] columnName = col.getPath().toArray();
                Statistics stats = col.getStatistics();
                PrimitiveType.PrimitiveTypeName primitiveTypeName = col.getPrimitiveType().getPrimitiveTypeName();
                this.addColumnMetadata(columnName, stats, primitiveTypeName, columnMetadataList);
                length += col.getTotalSize();
            }
            if (rowGroup.getRowCount() == 0L) continue;
            Metadata_V4.RowGroupMetadata_v4 rowGroupMeta = new Metadata_V4.RowGroupMetadata_v4(rowGroup.getStartingPos(), length, rowGroup.getRowCount(), this.getHostAffinity(rowGroup.getStartingPos(), length), columnMetadataList);
            rowGroupMetadataList.add(rowGroupMeta);
        }
        if (rowGroupMetadataList.isEmpty()) {
            ArrayList<Metadata_V4.ColumnMetadata_v4> columnMetadataList = new ArrayList<Metadata_V4.ColumnMetadata_v4>();
            for (ColumnDescriptor columnDescriptor : this.schema.getColumns()) {
                Statistics stats = Statistics.getBuilderForReading((PrimitiveType)columnDescriptor.getPrimitiveType()).withMax(null).withMin(null).withNumNulls(0L).build();
                this.addColumnMetadata(columnDescriptor.getPath(), stats, columnDescriptor.getPrimitiveType().getPrimitiveTypeName(), columnMetadataList);
            }
            Metadata_V4.RowGroupMetadata_v4 rowGroupMeta = new Metadata_V4.RowGroupMetadata_v4(0L, 0L, 0L, this.getHostAffinity(0L, 0L), columnMetadataList);
            rowGroupMetadataList.add(rowGroupMeta);
        }
        Path path = Path.getPathWithoutSchemeAndAuthority((Path)this.file.getPath());
        Metadata_V4.ParquetFileMetadata_v4 parquetFileMetadata_v4 = new Metadata_V4.ParquetFileMetadata_v4(path, this.file.getLen(), rowGroupMetadataList);
        this.fileMetadata = new Metadata_V4.ParquetFileAndRowCountMetadata(parquetFileMetadata_v4, this.totalNullCountMap, totalRowCount);
    }

    private void addColumnMetadata(String[] columnName, Statistics<?> stats, PrimitiveType.PrimitiveTypeName primitiveTypeName, List<Metadata_V4.ColumnMetadata_v4> columnMetadataList) {
        boolean thisColumnIsInteresting;
        SchemaPath columnSchemaName = SchemaPath.getCompoundPath(columnName);
        boolean bl = thisColumnIsInteresting = this.allColumnsInteresting || this.columnSet == null || this.columnSet.contains(SchemaPath.getSimplePath(columnSchemaName.getRootSegmentPath()));
        if (this.skipNonInteresting && !thisColumnIsInteresting) {
            return;
        }
        ColTypeInfo colTypeInfo = this.colTypeInfoMap.get(columnSchemaName);
        long totalNullCount = stats.getNumNulls();
        Metadata_V4.ColumnTypeMetadata_v4 columnTypeMetadata = new Metadata_V4.ColumnTypeMetadata_v4.Builder().name(columnName).primitiveType(primitiveTypeName).originalType(colTypeInfo.originalType).precision(colTypeInfo.precision).scale(colTypeInfo.scale).repetitionLevel(colTypeInfo.repetitionLevel).definitionLevel(colTypeInfo.definitionLevel).totalNullCount(0L).interesting(false).parentTypes(colTypeInfo.parentTypes).repetition(colTypeInfo.repetition).build();
        Metadata_V4.ColumnTypeMetadata_v4.Key columnTypeMetadataKey = new Metadata_V4.ColumnTypeMetadata_v4.Key(columnTypeMetadata.name);
        this.totalNullCountMap.putIfAbsent(columnTypeMetadataKey, Metadata.DEFAULT_NULL_COUNT);
        if (this.totalNullCountMap.get(columnTypeMetadataKey) < 0L || totalNullCount < 0L) {
            this.totalNullCountMap.put(columnTypeMetadataKey, Metadata.NULL_COUNT_NOT_EXISTS);
        } else {
            long nullCount = this.totalNullCountMap.get(columnTypeMetadataKey) + totalNullCount;
            this.totalNullCountMap.put(columnTypeMetadataKey, nullCount);
        }
        if (thisColumnIsInteresting) {
            Object minValue = null;
            Object maxValue = null;
            if (!stats.isEmpty() && stats.hasNonNullValue()) {
                minValue = stats.genericGetMin();
                maxValue = stats.genericGetMax();
                if (this.containsCorruptDates == ParquetReaderUtility.DateCorruptionStatus.META_SHOWS_CORRUPTION && columnTypeMetadata.originalType == OriginalType.DATE) {
                    minValue = ParquetReaderUtility.autoCorrectCorruptedDate((Integer)minValue);
                    maxValue = ParquetReaderUtility.autoCorrectCorruptedDate((Integer)maxValue);
                }
                if (FileMetadataCollector.isMicrosecondColumnType(columnTypeMetadata.originalType)) {
                    minValue = FileMetadataCollector.truncateMicros(minValue);
                    maxValue = FileMetadataCollector.truncateMicros(maxValue);
                }
            }
            long numNulls = stats.getNumNulls();
            Metadata_V4.ColumnMetadata_v4 columnMetadata = new Metadata_V4.ColumnMetadata_v4(columnTypeMetadata.name, primitiveTypeName, minValue, maxValue, numNulls);
            columnMetadataList.add(columnMetadata);
            columnTypeMetadata.isInteresting = true;
        }
        this.columnTypeInfo.put(columnTypeMetadataKey, columnTypeMetadata);
    }

    private static boolean isMicrosecondColumnType(OriginalType columnType) {
        return columnType == OriginalType.TIME_MICROS || columnType == OriginalType.TIMESTAMP_MICROS;
    }

    private static Object truncateMicros(Object microSeconds) {
        if (microSeconds instanceof Number) {
            return ((Number)microSeconds).longValue() / 1000L;
        }
        return microSeconds;
    }

    private Map<String, Float> getHostAffinity(long start, long length) throws IOException {
        BlockLocation[] blockLocations;
        HashMap<String, Float> hostAffinityMap = new HashMap<String, Float>();
        for (BlockLocation blockLocation : blockLocations = this.fs.getFileBlockLocations(this.file, start, length)) {
            for (String host : blockLocation.getHosts()) {
                float affinity;
                if (length == 0L) {
                    affinity = 0.0f;
                } else {
                    float blockStart = blockLocation.getOffset();
                    float blockEnd = blockStart + (float)blockLocation.getLength();
                    float rowGroupEnd = start + length;
                    float calcStart = blockStart < (float)start ? (float)start - blockStart : 0.0f;
                    float calcEnd = blockEnd > rowGroupEnd ? blockEnd - rowGroupEnd : 0.0f;
                    affinity = ((float)blockLocation.getLength() - calcStart - calcEnd) / (float)length;
                }
                hostAffinityMap.merge(host, Float.valueOf(affinity), (currentAffinity, newAffinity) -> Float.valueOf(currentAffinity.floatValue() + newAffinity.floatValue()));
            }
        }
        return hostAffinityMap;
    }

    private static class ColTypeInfo {
        OriginalType originalType;
        List<OriginalType> parentTypes;
        int precision;
        int scale;
        int repetitionLevel;
        int definitionLevel;
        Type.Repetition repetition;

        private ColTypeInfo() {
        }

        static ColTypeInfo of(MessageType schema, Type type, String[] path, int depth, List<OriginalType> parentTypes) {
            if (type.isPrimitive()) {
                return ColTypeInfo.createColTypeInfo(type.asPrimitiveType(), schema, path, parentTypes);
            }
            Type t = ((GroupType)type).getType(path[depth]);
            if (!t.isPrimitive()) {
                OriginalType originalType = t.getOriginalType();
                if (originalType == OriginalType.MAP && !ParquetReaderUtility.isLogicalMapType(t.asGroupType())) {
                    originalType = null;
                } else if (originalType == OriginalType.LIST && !ParquetReaderUtility.isLogicalListType(t.asGroupType())) {
                    originalType = null;
                }
                parentTypes.add(originalType);
            }
            return ColTypeInfo.of(schema, t, path, depth + 1, parentTypes);
        }

        private static ColTypeInfo createColTypeInfo(PrimitiveType type, MessageType schema, String[] path, List<OriginalType> parentTypes) {
            int precision = 0;
            int scale = 0;
            if (type.getDecimalMetadata() != null) {
                precision = type.getDecimalMetadata().getPrecision();
                scale = type.getDecimalMetadata().getScale();
            }
            int repetitionLevel = schema.getMaxRepetitionLevel(path);
            int definitionLevel = schema.getMaxDefinitionLevel(path);
            int probableListIndex = parentTypes.size() - 2;
            Type.Repetition repetition = probableListIndex >= 0 && parentTypes.get(probableListIndex) == OriginalType.LIST ? Type.Repetition.REPEATED : type.getRepetition();
            return new ColTypeInfo().setOriginalType(type.getOriginalType()).setParentTypes(parentTypes).setPrecision(precision).setScale(scale).setRepetitionLevel(repetitionLevel).setDefinitionLevel(definitionLevel).setRepetition(repetition);
        }

        private ColTypeInfo setOriginalType(OriginalType originalType) {
            this.originalType = originalType;
            return this;
        }

        private ColTypeInfo setParentTypes(List<OriginalType> parentTypes) {
            this.parentTypes = parentTypes;
            return this;
        }

        private ColTypeInfo setPrecision(int precision) {
            this.precision = precision;
            return this;
        }

        private ColTypeInfo setScale(int scale) {
            this.scale = scale;
            return this;
        }

        private ColTypeInfo setRepetitionLevel(int repetitionLevel) {
            this.repetitionLevel = repetitionLevel;
            return this;
        }

        private ColTypeInfo setDefinitionLevel(int definitionLevel) {
            this.definitionLevel = definitionLevel;
            return this;
        }

        private ColTypeInfo setRepetition(Type.Repetition repetition) {
            this.repetition = repetition;
            return this;
        }
    }
}

