/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.metadata;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.drill.common.util.DrillVersionInfo;
import org.apache.drill.exec.store.parquet.metadata.Metadata;
import org.apache.drill.exec.store.parquet.metadata.MetadataBase;
import org.apache.drill.exec.store.parquet.metadata.MetadataVersion;
import org.apache.drill.exec.store.parquet.metadata.Metadata_V3;
import org.apache.drill.exec.store.parquet.metadata.Metadata_V4;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.fs.Path;

public class MetadataPathUtils {
    public static List<Path> convertToAbsolutePaths(List<Path> paths, String baseDir) {
        if (!paths.isEmpty()) {
            ArrayList<Path> absolutePaths = new ArrayList<Path>();
            for (Path relativePath : paths) {
                Path absolutePath = relativePath.isAbsolute() ? relativePath : new Path(baseDir, relativePath);
                absolutePaths.add(absolutePath);
            }
            return absolutePaths;
        }
        return paths;
    }

    public static List<? extends MetadataBase.ParquetFileMetadata> convertToFilesWithAbsolutePaths(List<? extends MetadataBase.ParquetFileMetadata> files, String baseDir) {
        if (!files.isEmpty()) {
            ArrayList<MetadataBase.ParquetFileMetadata> filesWithAbsolutePaths = new ArrayList<MetadataBase.ParquetFileMetadata>();
            for (MetadataBase.ParquetFileMetadata parquetFileMetadata : files) {
                Path relativePath = parquetFileMetadata.getPath();
                MetadataBase.ParquetFileMetadata fileWithAbsolutePath = null;
                if (parquetFileMetadata instanceof Metadata_V4.ParquetFileMetadata_v4) {
                    fileWithAbsolutePath = relativePath.isAbsolute() ? parquetFileMetadata : new Metadata_V4.ParquetFileMetadata_v4(new Path(baseDir, relativePath), parquetFileMetadata.getLength(), parquetFileMetadata.getRowGroups());
                } else if (parquetFileMetadata instanceof Metadata_V3.ParquetFileMetadata_v3) {
                    fileWithAbsolutePath = relativePath.isAbsolute() ? parquetFileMetadata : new Metadata_V3.ParquetFileMetadata_v3(new Path(baseDir, relativePath), parquetFileMetadata.getLength(), parquetFileMetadata.getRowGroups());
                }
                filesWithAbsolutePaths.add(fileWithAbsolutePath);
            }
            return filesWithAbsolutePaths;
        }
        return files;
    }

    public static Metadata_V4.ParquetTableMetadata_v4 createMetadataWithRelativePaths(Metadata_V4.ParquetTableMetadata_v4 tableMetadataWithAbsolutePaths, Path baseDir) {
        ArrayList<Path> directoriesWithRelativePaths = new ArrayList<Path>();
        for (Path directory : tableMetadataWithAbsolutePaths.getDirectories()) {
            directoriesWithRelativePaths.add(MetadataPathUtils.relativize(baseDir, directory));
        }
        ArrayList<Metadata_V4.ParquetFileMetadata_v4> filesWithRelativePaths = new ArrayList<Metadata_V4.ParquetFileMetadata_v4>();
        for (Metadata_V4.ParquetFileMetadata_v4 parquetFileMetadata_v4 : tableMetadataWithAbsolutePaths.getFiles()) {
            filesWithRelativePaths.add(new Metadata_V4.ParquetFileMetadata_v4(MetadataPathUtils.relativize(baseDir, parquetFileMetadata_v4.getPath()), parquetFileMetadata_v4.length, parquetFileMetadata_v4.rowGroups));
        }
        return new Metadata_V4.ParquetTableMetadata_v4(MetadataVersion.Constants.SUPPORTED_VERSIONS.last().toString(), tableMetadataWithAbsolutePaths, filesWithRelativePaths, directoriesWithRelativePaths, DrillVersionInfo.getVersion(), tableMetadataWithAbsolutePaths.getTotalRowCount(), tableMetadataWithAbsolutePaths.isAllColumnsInteresting());
    }

    public static Path relativize(Path baseDir, Path childPath) {
        Path fullPathWithoutSchemeAndAuthority = Path.getPathWithoutSchemeAndAuthority((Path)childPath);
        Path basePathWithoutSchemeAndAuthority = Path.getPathWithoutSchemeAndAuthority((Path)baseDir);
        Path relativeFilePath = new Path(basePathWithoutSchemeAndAuthority.toUri().relativize(fullPathWithoutSchemeAndAuthority.toUri()));
        if (relativeFilePath.isAbsolute()) {
            throw new IllegalStateException(String.format("Path %s is not a subpath of %s.", basePathWithoutSchemeAndAuthority.toUri().getPath(), fullPathWithoutSchemeAndAuthority.toUri().getPath()));
        }
        return relativeFilePath;
    }

    @VisibleForTesting
    public static boolean checkForMetadataFile(String basePath, String table) {
        for (String filename : Metadata.CURRENT_METADATA_FILENAMES) {
            File metaFile;
            File file = metaFile = table.startsWith(basePath) ? FileUtils.getFile((String[])new String[]{table, filename}) : FileUtils.getFile((String[])new String[]{basePath, table, filename});
            if (Files.exists(metaFile.toPath(), new LinkOption[0])) continue;
            return false;
        }
        return true;
    }
}

