/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.metadata;

import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ComparisonChain;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSortedSet;

public class MetadataVersion
implements Comparable<MetadataVersion> {
    private static final String FORMAT = "v?((?!0)\\d+)(\\.(\\d+))?";
    private static final Pattern PATTERN = Pattern.compile("v?((?!0)\\d+)(\\.(\\d+))?");
    private final int major;
    private final int minor;

    public MetadataVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public MetadataVersion(String metadataVersion) {
        Matcher matcher = PATTERN.matcher(metadataVersion);
        if (!matcher.matches()) {
            throw DrillRuntimeException.create("Could not parse metadata version '%s' using format '%s'", metadataVersion, FORMAT);
        }
        this.major = Integer.parseInt(matcher.group(1));
        this.minor = matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetadataVersion)) {
            return false;
        }
        MetadataVersion that = (MetadataVersion)o;
        return this.major == that.major && this.minor == that.minor;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.major);
        if (this.minor != 0) {
            builder.append(".").append(this.minor);
        }
        return builder.toString();
    }

    @Override
    public int compareTo(MetadataVersion o) {
        Preconditions.checkNotNull(o);
        return ComparisonChain.start().compare(this.major, o.major).compare(this.minor, o.minor).result();
    }

    public boolean isAtLeast(int major, int minor) {
        return this.major > major || this.major == major && this.minor >= minor;
    }

    public boolean isEqualTo(int major, int minor) {
        return this.major == major && this.minor == minor;
    }

    public boolean isHigherThan(int major, int minor) {
        return this.major > major || this.major == major && this.minor > minor;
    }

    public static class Constants {
        public static final String V1 = "v1";
        public static final String V2 = "v2";
        public static final String V3 = "v3";
        public static final String V3_1 = "3.1";
        public static final String V3_2 = "3.2";
        public static final String V3_3 = "3.3";
        public static final String V4 = "4.0";
        public static final String V4_1 = "4.1";
        public static final String V4_2 = "4.2";
        public static final SortedSet<MetadataVersion> SUPPORTED_VERSIONS = ImmutableSortedSet.of((Comparable)new MetadataVersion("v1"), (Comparable)new MetadataVersion("v2"), (Comparable)new MetadataVersion("v3"), (Comparable)new MetadataVersion("3.1"), (Comparable)new MetadataVersion("3.2"), (Comparable)new MetadataVersion("3.3"), (Comparable[])new MetadataVersion[]{new MetadataVersion("4.0"), new MetadataVersion("4.1"), new MetadataVersion("4.2")});

        public static boolean isVersionSupported(String metadataVersion) {
            return SUPPORTED_VERSIONS.contains(new MetadataVersion(metadataVersion));
        }
    }
}

