/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.drill.exec.store.parquet.metadata.MetadataBase;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;

public class Metadata_V2 {

    public static class ColumnMetadata_v2
    extends MetadataBase.ColumnMetadata {
        @JsonProperty
        public String[] name;
        @JsonProperty
        public Long nulls;
        public Object mxValue;
        @JsonIgnore
        private PrimitiveType.PrimitiveTypeName primitiveType;

        public ColumnMetadata_v2() {
        }

        public ColumnMetadata_v2(String[] name, PrimitiveType.PrimitiveTypeName primitiveType, Object mxValue, Long nulls) {
            this.name = name;
            this.mxValue = mxValue;
            this.nulls = nulls;
            this.primitiveType = primitiveType;
        }

        @Override
        @JsonProperty(value="mxValue")
        public void setMax(Object mxValue) {
            this.mxValue = mxValue;
        }

        @Override
        public String[] getName() {
            return this.name;
        }

        @Override
        public Long getNulls() {
            return this.nulls;
        }

        @Override
        public boolean hasSingleValue(long rowCount) {
            if (this.nulls != null) {
                return this.mxValue != null && this.nulls == 0L || this.nulls == rowCount;
            }
            return false;
        }

        @Override
        public Object getMinValue() {
            return this.mxValue;
        }

        @Override
        public Object getMaxValue() {
            return this.mxValue;
        }

        @Override
        public void setMin(Object newMin) {
        }

        @Override
        public PrimitiveType.PrimitiveTypeName getPrimitiveType() {
            return this.primitiveType;
        }

        @Override
        public OriginalType getOriginalType() {
            return null;
        }

        public static class Serializer
        extends JsonSerializer<ColumnMetadata_v2> {
            public void serialize(ColumnMetadata_v2 value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeStartObject();
                jgen.writeArrayFieldStart("name");
                for (String n : value.name) {
                    jgen.writeString(n);
                }
                jgen.writeEndArray();
                if (value.mxValue != null) {
                    Object val = value.primitiveType == PrimitiveType.PrimitiveTypeName.BINARY && value.mxValue != null ? new String(((Binary)value.mxValue).getBytes(), StandardCharsets.UTF_8) : value.mxValue;
                    jgen.writeObjectField("mxValue", val);
                }
                if (value.nulls != null) {
                    jgen.writeObjectField("nulls", (Object)value.nulls);
                }
                jgen.writeEndObject();
            }
        }

        public static class DeSerializer
        extends JsonDeserializer<ColumnMetadata_v2> {
            public ColumnMetadata_v2 deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                return null;
            }
        }
    }

    public static class ColumnTypeMetadata_v2
    extends MetadataBase.ColumnTypeMetadata {
        @JsonProperty
        public String[] name;
        @JsonProperty
        public PrimitiveType.PrimitiveTypeName primitiveType;
        @JsonProperty
        public OriginalType originalType;
        @JsonIgnore
        private Key key;

        public ColumnTypeMetadata_v2() {
        }

        public ColumnTypeMetadata_v2(String[] name, PrimitiveType.PrimitiveTypeName primitiveType, OriginalType originalType) {
            this.name = name;
            this.primitiveType = primitiveType;
            this.originalType = originalType;
            this.key = new Key(name);
        }

        @JsonIgnore
        private Key key() {
            return this.key;
        }

        @Override
        public PrimitiveType.PrimitiveTypeName getPrimitiveType() {
            return this.primitiveType;
        }

        @Override
        public String[] getName() {
            return this.name;
        }

        public static class Key {
            private String[] name;
            private int hashCode = 0;

            public Key(String[] name) {
                this.name = name;
            }

            public int hashCode() {
                if (this.hashCode == 0) {
                    this.hashCode = Arrays.hashCode(this.name);
                }
                return this.hashCode;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                return Arrays.equals(this.name, other.name);
            }

            public String toString() {
                String s = null;
                for (String namePart : this.name) {
                    if (s != null) {
                        s = s + ".";
                        s = s + namePart;
                        continue;
                    }
                    s = namePart;
                }
                return s;
            }

            public static class DeSerializer
            extends KeyDeserializer {
                public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    return new Key(key.split("\\."));
                }
            }
        }
    }

    public static class RowGroupMetadata_v2
    extends MetadataBase.RowGroupMetadata {
        @JsonProperty
        public Long start;
        @JsonProperty
        public Long length;
        @JsonProperty
        public Long rowCount;
        @JsonProperty
        public Map<String, Float> hostAffinity;
        @JsonProperty
        public List<ColumnMetadata_v2> columns;

        public RowGroupMetadata_v2() {
        }

        public RowGroupMetadata_v2(Long start, Long length, Long rowCount, Map<String, Float> hostAffinity, List<ColumnMetadata_v2> columns) {
            this.start = start;
            this.length = length;
            this.rowCount = rowCount;
            this.hostAffinity = hostAffinity;
            this.columns = columns;
        }

        @Override
        public Long getStart() {
            return this.start;
        }

        @Override
        public Long getLength() {
            return this.length;
        }

        @Override
        public Long getRowCount() {
            return this.rowCount;
        }

        @Override
        public Map<String, Float> getHostAffinity() {
            return this.hostAffinity;
        }

        @Override
        public List<? extends MetadataBase.ColumnMetadata> getColumns() {
            return this.columns;
        }
    }

    public static class ParquetFileMetadata_v2
    extends MetadataBase.ParquetFileMetadata {
        @JsonProperty
        public Path path;
        @JsonProperty
        public Long length;
        @JsonProperty
        public List<RowGroupMetadata_v2> rowGroups;

        public ParquetFileMetadata_v2() {
        }

        public ParquetFileMetadata_v2(Path path, Long length, List<RowGroupMetadata_v2> rowGroups) {
            this.path = path;
            this.length = length;
            this.rowGroups = rowGroups;
        }

        public String toString() {
            return String.format("path: %s rowGroups: %s", this.path, this.rowGroups);
        }

        @Override
        @JsonIgnore
        public Path getPath() {
            return this.path;
        }

        @Override
        @JsonIgnore
        public Long getLength() {
            return this.length;
        }

        @Override
        @JsonIgnore
        public List<? extends MetadataBase.RowGroupMetadata> getRowGroups() {
            return this.rowGroups;
        }
    }

    @JsonTypeName(value="v2")
    public static class ParquetTableMetadata_v2
    extends MetadataBase.ParquetTableMetadataBase {
        @JsonProperty(value="metadata_version", access=JsonProperty.Access.WRITE_ONLY)
        private String metadataVersion;
        @JsonProperty
        public ConcurrentHashMap<ColumnTypeMetadata_v2.Key, ColumnTypeMetadata_v2> columnTypeInfo;
        @JsonProperty
        List<ParquetFileMetadata_v2> files;
        @JsonProperty
        List<Path> directories;
        @JsonProperty
        String drillVersion;

        public ParquetTableMetadata_v2() {
        }

        public ParquetTableMetadata_v2(String metadataVersion, String drillVersion) {
            this.metadataVersion = metadataVersion;
            this.drillVersion = drillVersion;
        }

        public ParquetTableMetadata_v2(String metadataVersion, MetadataBase.ParquetTableMetadataBase parquetTable, List<ParquetFileMetadata_v2> files, List<Path> directories, String drillVersion) {
            this.metadataVersion = metadataVersion;
            this.files = files;
            this.directories = directories;
            this.columnTypeInfo = ((ParquetTableMetadata_v2)parquetTable).columnTypeInfo;
            this.drillVersion = drillVersion;
        }

        public ParquetTableMetadata_v2(String metadataVersion, List<ParquetFileMetadata_v2> files, List<Path> directories, ConcurrentHashMap<ColumnTypeMetadata_v2.Key, ColumnTypeMetadata_v2> columnTypeInfo, String drillVersion) {
            this.metadataVersion = metadataVersion;
            this.files = files;
            this.directories = directories;
            this.columnTypeInfo = columnTypeInfo;
            this.drillVersion = drillVersion;
        }

        public ColumnTypeMetadata_v2 getColumnTypeInfo(String[] name) {
            return this.columnTypeInfo.get(new ColumnTypeMetadata_v2.Key(name));
        }

        @Override
        @JsonIgnore
        public List<Path> getDirectories() {
            return this.directories;
        }

        @Override
        @JsonIgnore
        public List<? extends MetadataBase.ParquetFileMetadata> getFiles() {
            return this.files;
        }

        @Override
        @JsonIgnore
        public void assignFiles(List<? extends MetadataBase.ParquetFileMetadata> newFiles) {
            this.files = newFiles;
        }

        @Override
        public boolean hasColumnMetadata() {
            return true;
        }

        @Override
        @JsonIgnore
        public PrimitiveType.PrimitiveTypeName getPrimitiveType(String[] columnName) {
            return this.getColumnTypeInfo((String[])columnName).primitiveType;
        }

        @Override
        @JsonIgnore
        public OriginalType getOriginalType(String[] columnName) {
            return this.getColumnTypeInfo((String[])columnName).originalType;
        }

        @Override
        @JsonIgnore
        public Integer getRepetitionLevel(String[] columnName) {
            return null;
        }

        @Override
        @JsonIgnore
        public Integer getDefinitionLevel(String[] columnName) {
            return null;
        }

        @Override
        @JsonIgnore
        public Integer getScale(String[] columnName) {
            return null;
        }

        @Override
        @JsonIgnore
        public Integer getPrecision(String[] columnName) {
            return null;
        }

        @Override
        @JsonIgnore
        public boolean isRowGroupPrunable() {
            return false;
        }

        @Override
        @JsonIgnore
        public MetadataBase.ParquetTableMetadataBase clone() {
            return new ParquetTableMetadata_v2(this.metadataVersion, this.files, this.directories, this.columnTypeInfo, this.drillVersion);
        }

        @Override
        @JsonIgnore
        public String getDrillVersion() {
            return this.drillVersion;
        }

        @Override
        @JsonIgnore
        public String getMetadataVersion() {
            return this.metadataVersion;
        }

        @JsonIgnore
        public ConcurrentHashMap<ColumnTypeMetadata_v2.Key, ColumnTypeMetadata_v2> getColumnTypeInfoMap() {
            return this.columnTypeInfo;
        }

        @Override
        public List<? extends MetadataBase.ColumnTypeMetadata> getColumnTypeInfoList() {
            return new ArrayList<ColumnTypeMetadata_v2>(this.columnTypeInfo.values());
        }
    }
}

