/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.store.parquet.metadata.MetadataBase;
import org.apache.drill.exec.store.parquet.metadata.MetadataPathUtils;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;

public class Metadata_V3 {

    public static class ColumnMetadata_v3
    extends MetadataBase.ColumnMetadata {
        @JsonProperty
        public String[] name;
        @JsonProperty
        public Long nulls;
        public Object minValue;
        public Object maxValue;
        @JsonIgnore
        private PrimitiveType.PrimitiveTypeName primitiveType;

        public ColumnMetadata_v3() {
        }

        public ColumnMetadata_v3(String[] name, PrimitiveType.PrimitiveTypeName primitiveType, Object minValue, Object maxValue, Long nulls) {
            this.name = name;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.nulls = nulls;
            this.primitiveType = primitiveType;
        }

        @Override
        @JsonProperty(value="minValue")
        public void setMin(Object minValue) {
            this.minValue = minValue;
        }

        @Override
        @JsonProperty(value="maxValue")
        public void setMax(Object maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public String[] getName() {
            return this.name;
        }

        @Override
        public Long getNulls() {
            return this.nulls;
        }

        @Override
        public boolean hasSingleValue(long rowCount) {
            if (this.isNumNullsSet()) {
                if (this.minValue != null) {
                    return (this.nulls == 0L || this.nulls == rowCount) && Objects.deepEquals(this.minValue, this.maxValue);
                }
                return this.nulls == rowCount && this.maxValue == null;
            }
            return false;
        }

        @Override
        public Object getMinValue() {
            return this.minValue;
        }

        @Override
        public Object getMaxValue() {
            return this.maxValue;
        }

        @Override
        public PrimitiveType.PrimitiveTypeName getPrimitiveType() {
            return null;
        }

        @Override
        public OriginalType getOriginalType() {
            return null;
        }

        public static class Serializer
        extends JsonSerializer<ColumnMetadata_v3> {
            public void serialize(ColumnMetadata_v3 value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                Object val;
                jgen.writeStartObject();
                jgen.writeArrayFieldStart("name");
                for (String n : value.name) {
                    jgen.writeString(n);
                }
                jgen.writeEndArray();
                if (value.minValue != null) {
                    val = value.primitiveType == PrimitiveType.PrimitiveTypeName.BINARY || value.primitiveType == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY ? ((Binary)value.minValue).getBytes() : (Object)value.minValue;
                    jgen.writeObjectField("minValue", val);
                }
                if (value.maxValue != null) {
                    val = value.primitiveType == PrimitiveType.PrimitiveTypeName.BINARY || value.primitiveType == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY ? ((Binary)value.maxValue).getBytes() : (Object)value.maxValue;
                    jgen.writeObjectField("maxValue", val);
                }
                if (value.nulls != null) {
                    jgen.writeObjectField("nulls", (Object)value.nulls);
                }
                jgen.writeEndObject();
            }
        }
    }

    public static class ColumnTypeMetadata_v3
    extends MetadataBase.ColumnTypeMetadata {
        @JsonProperty
        public String[] name;
        @JsonProperty
        public PrimitiveType.PrimitiveTypeName primitiveType;
        @JsonProperty
        public OriginalType originalType;
        @JsonProperty
        public int precision;
        @JsonProperty
        public int scale;
        @JsonProperty
        public int repetitionLevel;
        @JsonProperty
        public int definitionLevel;
        @JsonIgnore
        private Key key;

        public ColumnTypeMetadata_v3() {
        }

        public ColumnTypeMetadata_v3(String[] name, PrimitiveType.PrimitiveTypeName primitiveType, OriginalType originalType, int precision, int scale, int repetitionLevel, int definitionLevel) {
            this.name = name;
            this.primitiveType = primitiveType;
            this.originalType = originalType;
            this.precision = precision;
            this.scale = scale;
            this.repetitionLevel = repetitionLevel;
            this.definitionLevel = definitionLevel;
            this.key = new Key(name);
        }

        @JsonIgnore
        private Key key() {
            return this.key;
        }

        @Override
        public PrimitiveType.PrimitiveTypeName getPrimitiveType() {
            return this.primitiveType;
        }

        @Override
        public String[] getName() {
            return this.name;
        }

        public static class Key {
            private SchemaPath name;
            private int hashCode = 0;

            public Key(String[] name) {
                this.name = SchemaPath.getCompoundPath(name);
            }

            public Key(SchemaPath name) {
                this.name = new SchemaPath(name);
            }

            public int hashCode() {
                if (this.hashCode == 0) {
                    this.hashCode = this.name.hashCode();
                }
                return this.hashCode;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                return this.name.equals(other.name);
            }

            public String toString() {
                return this.name.toString();
            }

            public static class DeSerializer
            extends KeyDeserializer {
                public Object deserializeKey(String key, DeserializationContext ctxt) {
                    if (key.contains("`")) {
                        return new Key(SchemaPath.parseFromString(key));
                    }
                    return new Key(key.split("\\."));
                }
            }
        }
    }

    public static class RowGroupMetadata_v3
    extends MetadataBase.RowGroupMetadata {
        @JsonProperty
        public Long start;
        @JsonProperty
        public Long length;
        @JsonProperty
        public Long rowCount;
        @JsonProperty
        public Map<String, Float> hostAffinity;
        @JsonProperty
        public List<ColumnMetadata_v3> columns;

        public RowGroupMetadata_v3() {
        }

        public RowGroupMetadata_v3(Long start, Long length, Long rowCount, Map<String, Float> hostAffinity, List<ColumnMetadata_v3> columns) {
            this.start = start;
            this.length = length;
            this.rowCount = rowCount;
            this.hostAffinity = hostAffinity;
            this.columns = columns;
        }

        @Override
        public Long getStart() {
            return this.start;
        }

        @Override
        public Long getLength() {
            return this.length;
        }

        @Override
        public Long getRowCount() {
            return this.rowCount;
        }

        @Override
        public Map<String, Float> getHostAffinity() {
            return this.hostAffinity;
        }

        @Override
        public List<? extends MetadataBase.ColumnMetadata> getColumns() {
            return this.columns;
        }
    }

    public static class ParquetFileMetadata_v3
    extends MetadataBase.ParquetFileMetadata {
        @JsonProperty
        public Path path;
        @JsonProperty
        public Long length;
        @JsonProperty
        public List<RowGroupMetadata_v3> rowGroups;

        public ParquetFileMetadata_v3() {
        }

        public ParquetFileMetadata_v3(Path path, Long length, List<RowGroupMetadata_v3> rowGroups) {
            this.path = path;
            this.length = length;
            this.rowGroups = rowGroups;
        }

        public String toString() {
            return String.format("path: %s rowGroups: %s", this.path, this.rowGroups);
        }

        @Override
        @JsonIgnore
        public Path getPath() {
            return this.path;
        }

        @Override
        @JsonIgnore
        public Long getLength() {
            return this.length;
        }

        @Override
        @JsonIgnore
        public List<? extends MetadataBase.RowGroupMetadata> getRowGroups() {
            return this.rowGroups;
        }
    }

    @JsonTypeName(value="3.3")
    public static class ParquetTableMetadata_v3
    extends MetadataBase.ParquetTableMetadataBase {
        @JsonProperty(value="metadata_version", access=JsonProperty.Access.WRITE_ONLY)
        private String metadataVersion;
        @JsonProperty
        public ConcurrentHashMap<ColumnTypeMetadata_v3.Key, ColumnTypeMetadata_v3> columnTypeInfo;
        @JsonProperty
        List<ParquetFileMetadata_v3> files;
        @JsonProperty
        List<Path> directories;
        @JsonProperty
        String drillVersion;

        public ParquetTableMetadata_v3() {
        }

        public ParquetTableMetadata_v3(String metadataVersion, String drillVersion) {
            this.metadataVersion = metadataVersion;
            this.drillVersion = drillVersion;
        }

        public ParquetTableMetadata_v3(String metadataVersion, MetadataBase.ParquetTableMetadataBase parquetTable, List<ParquetFileMetadata_v3> files, List<Path> directories, String drillVersion) {
            this.metadataVersion = metadataVersion;
            this.files = files;
            this.directories = directories;
            this.columnTypeInfo = ((ParquetTableMetadata_v3)parquetTable).columnTypeInfo;
            this.drillVersion = drillVersion;
        }

        public ParquetTableMetadata_v3(String metadataVersion, List<ParquetFileMetadata_v3> files, List<Path> directories, ConcurrentHashMap<ColumnTypeMetadata_v3.Key, ColumnTypeMetadata_v3> columnTypeInfo, String drillVersion) {
            this.metadataVersion = metadataVersion;
            this.files = files;
            this.directories = directories;
            this.columnTypeInfo = columnTypeInfo;
            this.drillVersion = drillVersion;
        }

        public ColumnTypeMetadata_v3 getColumnTypeInfo(String[] name) {
            return this.columnTypeInfo.get(new ColumnTypeMetadata_v3.Key(name));
        }

        @Override
        @JsonIgnore
        public List<Path> getDirectories() {
            return this.directories;
        }

        @Override
        @JsonIgnore
        public String getMetadataVersion() {
            return this.metadataVersion;
        }

        @JsonIgnore
        public void updateRelativePaths(String baseDir) {
            this.directories = MetadataPathUtils.convertToAbsolutePaths(this.directories, baseDir);
            this.files = MetadataPathUtils.convertToFilesWithAbsolutePaths(this.files, baseDir);
        }

        @Override
        @JsonIgnore
        public List<? extends MetadataBase.ParquetFileMetadata> getFiles() {
            return this.files;
        }

        @Override
        @JsonIgnore
        public void assignFiles(List<? extends MetadataBase.ParquetFileMetadata> newFiles) {
            this.files = newFiles;
        }

        @Override
        public boolean hasColumnMetadata() {
            return true;
        }

        @Override
        @JsonIgnore
        public PrimitiveType.PrimitiveTypeName getPrimitiveType(String[] columnName) {
            return this.getColumnTypeInfo((String[])columnName).primitiveType;
        }

        @Override
        @JsonIgnore
        public OriginalType getOriginalType(String[] columnName) {
            return this.getColumnTypeInfo((String[])columnName).originalType;
        }

        @Override
        @JsonIgnore
        public Integer getRepetitionLevel(String[] columnName) {
            return this.getColumnTypeInfo((String[])columnName).repetitionLevel;
        }

        @Override
        @JsonIgnore
        public Integer getDefinitionLevel(String[] columnName) {
            return this.getColumnTypeInfo((String[])columnName).definitionLevel;
        }

        @Override
        @JsonIgnore
        public Integer getScale(String[] columnName) {
            return this.getColumnTypeInfo((String[])columnName).scale;
        }

        @Override
        @JsonIgnore
        public Integer getPrecision(String[] columnName) {
            return this.getColumnTypeInfo((String[])columnName).precision;
        }

        @Override
        @JsonIgnore
        public boolean isRowGroupPrunable() {
            return true;
        }

        @Override
        @JsonIgnore
        public MetadataBase.ParquetTableMetadataBase clone() {
            return new ParquetTableMetadata_v3(this.metadataVersion, this.files, this.directories, this.columnTypeInfo, this.drillVersion);
        }

        @Override
        @JsonIgnore
        public String getDrillVersion() {
            return this.drillVersion;
        }

        @JsonIgnore
        public ConcurrentHashMap<ColumnTypeMetadata_v3.Key, ColumnTypeMetadata_v3> getColumnTypeInfoMap() {
            return this.columnTypeInfo;
        }

        @Override
        public List<? extends MetadataBase.ColumnTypeMetadata> getColumnTypeInfoList() {
            return new ArrayList<ColumnTypeMetadata_v3>(this.columnTypeInfo.values());
        }
    }
}

