/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet2;

import java.util.Collections;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.parquet.ParquetReaderUtility;
import org.apache.drill.exec.store.parquet2.DrillParquetGroupConverter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;

class DrillParquetMapGroupConverter
extends DrillParquetGroupConverter {
    private final BaseWriter.DictWriter writer;

    DrillParquetMapGroupConverter(OutputMutator mutator, BaseWriter.DictWriter mapWriter, GroupType schema, OptionManager options, ParquetReaderUtility.DateCorruptionStatus containsCorruptedDates) {
        super(mutator, mapWriter, options, containsCorruptedDates);
        this.writer = mapWriter;
        GroupType type = schema.getType(0).asGroupType();
        KeyValueGroupConverter innerConverter = new KeyValueGroupConverter(mutator, type, options, containsCorruptedDates);
        this.converters.add(innerConverter);
    }

    @Override
    public void start() {
        this.writer.start();
    }

    @Override
    public void end() {
        this.writer.end();
    }

    private class KeyValueGroupConverter
    extends DrillParquetGroupConverter {
        private static final int INDEX_KEY = 0;
        private static final int INDEX_VALUE = 1;

        KeyValueGroupConverter(OutputMutator mutator, GroupType schema, OptionManager options, ParquetReaderUtility.DateCorruptionStatus containsCorruptedDates) {
            super(mutator, DrillParquetMapGroupConverter.this.writer, options, containsCorruptedDates);
            this.converters.add(this.getKeyConverter(schema));
            this.converters.add(this.getValueConverter(schema, mutator, options, containsCorruptedDates));
        }

        private Converter getKeyConverter(GroupType schema) {
            Type keyType = schema.getType(0);
            if (!keyType.isPrimitive()) {
                throw new DrillRuntimeException("Dict supports primitive key only. Found: " + keyType);
            }
            return this.getConverterForType("key", keyType.asPrimitiveType());
        }

        private Converter getValueConverter(GroupType schema, OutputMutator mutator, OptionManager options, ParquetReaderUtility.DateCorruptionStatus containsCorruptedDates) {
            Object valueConverter;
            Type valueType = schema.getType(1);
            if (!valueType.isPrimitive()) {
                GroupType groupType = valueType.asGroupType();
                if (ParquetReaderUtility.isLogicalMapType(groupType)) {
                    BaseWriter.DictWriter valueWriter = DrillParquetMapGroupConverter.this.writer.dict("value");
                    valueConverter = new DrillParquetMapGroupConverter(mutator, valueWriter, groupType, options, containsCorruptedDates);
                } else {
                    boolean isListType = ParquetReaderUtility.isLogicalListType(groupType);
                    BaseWriter valueWriter = isListType ? DrillParquetMapGroupConverter.this.writer.list("value") : DrillParquetMapGroupConverter.this.writer.map("value");
                    valueConverter = new DrillParquetGroupConverter(mutator, valueWriter, groupType, Collections.emptyList(), options, containsCorruptedDates, isListType, "KeyValueGroupConverter");
                }
            } else {
                valueConverter = this.getConverterForType("value", valueType.asPrimitiveType());
            }
            return valueConverter;
        }

        @Override
        public void start() {
            DrillParquetMapGroupConverter.this.writer.startKeyValuePair();
        }

        @Override
        public void end() {
            DrillParquetMapGroupConverter.this.writer.endKeyValuePair();
        }

        @Override
        boolean isMapWriter() {
            return true;
        }
    }
}

