/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.plan.rel;

import java.io.IOException;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.planner.logical.DynamicDrillTable;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.plan.rel.StoragePluginTableScan;
import org.apache.drill.exec.util.Utilities;

public class PluginDrillTable
extends DynamicDrillTable
implements TranslatableTable {
    private final Convention convention;

    public PluginDrillTable(StoragePlugin plugin, String storageEngineName, String userName, DrillTableSelection selection, Convention convention) {
        super(plugin, storageEngineName, userName, selection);
        this.convention = convention;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable table) {
        DrillTable drillTable = Utilities.getDrillTable(table);
        try {
            return new StoragePluginTableScan(context.getCluster(), context.getCluster().traitSetOf((RelTrait)this.convention), drillTable.getGroupScan(), table, table.getRowType());
        }
        catch (IOException e) {
            throw new DrillRuntimeException(e);
        }
    }
}

