/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.plan.rel;

import java.io.IOException;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.physical.LeafPrel;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.store.SubsetRemover;
import org.apache.drill.exec.store.plan.PluginImplementor;
import org.apache.drill.exec.store.plan.rel.PluginIntermediatePrel;
import org.apache.drill.exec.store.plan.rel.PluginRel;

public class PluginPrel
extends AbstractRelNode
implements LeafPrel {
    private final GroupScan groupScan;
    private final RelDataType rowType;

    public PluginPrel(RelOptCluster cluster, PluginIntermediatePrel intermediatePrel) {
        super(cluster, intermediatePrel.getTraitSet());
        this.rowType = intermediatePrel.getRowType();
        PluginRel input = (PluginRel)intermediatePrel.getInput().accept(SubsetRemover.INSTANCE);
        try {
            PluginImplementor implementor = intermediatePrel.getPluginImplementor();
            input.implement(implementor);
            this.groupScan = implementor.getPhysicalOperator();
        }
        catch (IOException e) {
            throw new DrillRuntimeException(e);
        }
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) {
        return creator.addMetadata(this, this.groupScan);
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    @Override
    public boolean needsFinalColumnReordering() {
        return false;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("groupScan", (Object)this.groupScan);
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return this.groupScan.getScanStats(mq).getRecordCount();
    }

    protected RelDataType deriveRowType() {
        return this.rowType;
    }
}

