/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.plan.rule;

import java.util.Collections;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.drill.exec.planner.common.DrillLimitRelBase;
import org.apache.drill.exec.store.plan.PluginImplementor;
import org.apache.drill.exec.store.plan.rel.PluginLimitRel;
import org.apache.drill.exec.store.plan.rule.PluginConverterRule;

public class PluginLimitRule
extends PluginConverterRule {
    public PluginLimitRule(RelTrait in, Convention out, PluginImplementor pluginImplementor) {
        super(DrillLimitRelBase.class, in, out, "PluginLimitRule", pluginImplementor);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        DrillLimitRelBase limit = (DrillLimitRelBase)call.rel(0);
        return !limit.isPushDown() && super.matches(call);
    }

    public RelNode convert(RelNode rel) {
        DrillLimitRelBase limit = (DrillLimitRelBase)rel;
        PluginLimitRel pluginLimitRel = this.getPluginLimitRel(limit);
        if (this.getPluginImplementor().artificialLimit()) {
            return limit.copy(limit.getTraitSet(), Collections.singletonList(pluginLimitRel));
        }
        return pluginLimitRel;
    }

    private PluginLimitRel getPluginLimitRel(DrillLimitRelBase limit) {
        RelNode input = PluginLimitRule.convert((RelNode)limit.getInput(), (RelTraitSet)limit.getInput().getTraitSet().replace((RelTrait)this.getOutConvention()).simplify());
        return new PluginLimitRel(limit.getCluster(), limit.getTraitSet().replace((RelTrait)this.getOutConvention()), input, limit.getOffset(), limit.getFetch(), true);
    }
}

