/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.pojo;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdConverter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.store.pojo.AbstractPojoRecordReader;
import org.apache.drill.exec.store.pojo.PojoWriter;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

@JsonTypeName(value="dynamic-pojo-record-reader")
public class DynamicPojoRecordReader<T>
extends AbstractPojoRecordReader<List<T>> {
    @JsonProperty
    private LinkedHashMap<String, Class<?>> schema;

    public DynamicPojoRecordReader(LinkedHashMap<String, Class<?>> schema, List<List<T>> records) {
        super(records);
        this.validateAndSetSchema(schema);
    }

    public DynamicPojoRecordReader(LinkedHashMap<String, Class<?>> schema, List<List<T>> records, int maxRecordsToRead) {
        super(records, maxRecordsToRead);
        this.validateAndSetSchema(schema);
    }

    @Override
    protected List<PojoWriter> setupWriters(OutputMutator output) throws ExecutionSetupException {
        ArrayList<PojoWriter> writers = new ArrayList<PojoWriter>();
        for (Map.Entry<String, Class<?>> field : this.schema.entrySet()) {
            writers.add(this.initWriter(field.getValue(), field.getKey(), output));
        }
        return writers;
    }

    @Override
    protected Object getFieldValue(List<T> row, int fieldPosition) {
        return row.get(fieldPosition);
    }

    @Override
    public String toString() {
        return "DynamicPojoRecordReader{records = " + this.records + "}";
    }

    private void validateAndSetSchema(LinkedHashMap<String, Class<?>> schema) {
        Preconditions.checkState(schema != null && !schema.isEmpty(), "Undefined schema is not allowed.");
        this.schema = schema;
    }

    public static class Converter
    extends StdConverter<JsonNode, DynamicPojoRecordReader> {
        private static final TypeReference<LinkedHashMap<String, Class<?>>> schemaType = new TypeReference<LinkedHashMap<String, Class<?>>>(){};
        private final ObjectMapper mapper;

        public Converter(ObjectMapper mapper) {
            this.mapper = mapper;
        }

        public DynamicPojoRecordReader convert(JsonNode value) {
            LinkedHashMap schema = (LinkedHashMap)this.mapper.convertValue((Object)value.get("schema"), schemaType);
            ArrayList records = new ArrayList();
            JsonNode serializedRecords = value.get("records");
            for (JsonNode serializedRecord : serializedRecords) {
                ArrayList<Object> record = new ArrayList<Object>(schema.size());
                Iterator recordsIterator = serializedRecord.elements();
                for (Class fieldType : schema.values()) {
                    record.add(this.mapper.convertValue(recordsIterator.next(), fieldType));
                }
                records.add(record);
            }
            int maxRecordsToRead = value.get("recordsPerBatch").asInt();
            return new DynamicPojoRecordReader(schema, records, maxRecordsToRead);
        }
    }
}

