/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.pojo;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.exec.store.RecordDataType;
import org.apache.drill.exec.store.pojo.NonNullable;

public class PojoDataType
extends RecordDataType {
    private final List<AbstractMap.SimpleImmutableEntry<SqlTypeName, Boolean>> types = new ArrayList<AbstractMap.SimpleImmutableEntry<SqlTypeName, Boolean>>();
    private final List<String> names = new ArrayList<String>();
    private final Class<?> pojoClass;

    public PojoDataType(Class<?> pojoClass) {
        this.pojoClass = pojoClass;
        for (Field f : pojoClass.getDeclaredFields()) {
            boolean isNullable;
            if (Modifier.isStatic(f.getModifiers())) continue;
            Class<?> type = f.getType();
            this.names.add(f.getName());
            boolean bl = isNullable = !f.isAnnotationPresent(NonNullable.class);
            if (type == Integer.TYPE || type == Integer.class) {
                this.types.add(new AbstractMap.SimpleImmutableEntry<SqlTypeName, Boolean>(SqlTypeName.INTEGER, isNullable));
                continue;
            }
            if (type == Boolean.TYPE || type == Boolean.class) {
                this.types.add(new AbstractMap.SimpleImmutableEntry<SqlTypeName, Boolean>(SqlTypeName.BOOLEAN, isNullable));
                continue;
            }
            if (type == Long.TYPE || type == Long.class) {
                this.types.add(new AbstractMap.SimpleImmutableEntry<SqlTypeName, Boolean>(SqlTypeName.BIGINT, isNullable));
                continue;
            }
            if (type == Double.TYPE || type == Double.class) {
                this.types.add(new AbstractMap.SimpleImmutableEntry<SqlTypeName, Boolean>(SqlTypeName.DOUBLE, isNullable));
                continue;
            }
            if (type == BigDecimal.class) {
                this.types.add(new AbstractMap.SimpleImmutableEntry<SqlTypeName, Boolean>(SqlTypeName.DECIMAL, isNullable));
                continue;
            }
            if (type == String.class) {
                this.types.add(new AbstractMap.SimpleImmutableEntry<SqlTypeName, Boolean>(SqlTypeName.VARCHAR, isNullable));
                continue;
            }
            if (type.isEnum()) {
                this.types.add(new AbstractMap.SimpleImmutableEntry<SqlTypeName, Boolean>(SqlTypeName.VARCHAR, isNullable));
                continue;
            }
            if (type == Timestamp.class) {
                this.types.add(new AbstractMap.SimpleImmutableEntry<SqlTypeName, Boolean>(SqlTypeName.TIMESTAMP, isNullable));
                continue;
            }
            throw new RuntimeException(String.format("PojoDataType doesn't yet support conversions from type [%s].", type));
        }
    }

    public Class<?> getPojoClass() {
        return this.pojoClass;
    }

    @Override
    public List<AbstractMap.SimpleImmutableEntry<SqlTypeName, Boolean>> getFieldSqlTypeNames() {
        return this.types;
    }

    @Override
    public List<String> getFieldNames() {
        return this.names;
    }
}

