/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.schedule;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.drill.exec.metrics.DrillMetrics;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.TimedCallable;
import org.apache.drill.exec.store.dfs.easy.FileWork;
import org.apache.drill.exec.store.schedule.CompleteFileWork;
import org.apache.drill.exec.store.schedule.EndpointByteMap;
import org.apache.drill.exec.store.schedule.EndpointByteMapImpl;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableRangeMap;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.apache.drill.shaded.guava.com.google.common.collect.Range;
import org.apache.drill.shaded.guava.com.google.common.collect.RangeMap;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockMapBuilder {
    static final Logger logger = LoggerFactory.getLogger(BlockMapBuilder.class);
    static final MetricRegistry metrics = DrillMetrics.getRegistry();
    static final String BLOCK_MAP_BUILDER_TIMER = MetricRegistry.name(BlockMapBuilder.class, (String[])new String[]{"blockMapBuilderTimer"});
    private final Map<Path, ImmutableRangeMap<Long, BlockLocation>> blockMapMap = Maps.newConcurrentMap();
    private final FileSystem fs;
    private final ImmutableMap<String, CoordinationProtos.DrillbitEndpoint> endPointMap;
    private final CompressionCodecFactory codecFactory;

    public BlockMapBuilder(FileSystem fs, Collection<CoordinationProtos.DrillbitEndpoint> endpoints) {
        this.fs = fs;
        this.codecFactory = new CompressionCodecFactory(fs.getConf());
        this.endPointMap = BlockMapBuilder.buildEndpointMap(endpoints);
    }

    private boolean compressed(FileStatus fileStatus) {
        return this.codecFactory.getCodec(fileStatus.getPath()) != null;
    }

    public List<CompleteFileWork> generateFileWork(List<FileStatus> files, boolean blockify) throws IOException {
        ArrayList readers = new ArrayList(files.size());
        for (FileStatus status : files) {
            readers.add(new BlockMapReader(status, blockify));
        }
        List<List> work = TimedCallable.run("Get block maps", logger, readers, 16);
        ArrayList<CompleteFileWork> singleList = Lists.newArrayList();
        for (List innerWorkList : work) {
            singleList.addAll(innerWorkList);
        }
        return singleList;
    }

    private ImmutableRangeMap<Long, BlockLocation> buildBlockMap(Path path) throws IOException {
        FileStatus status = this.fs.getFileStatus(path);
        return this.buildBlockMap(status);
    }

    private ImmutableRangeMap<Long, BlockLocation> buildBlockMap(FileStatus status) throws IOException {
        Timer.Context context = metrics.timer(BLOCK_MAP_BUILDER_TIMER).time();
        BlockLocation[] blocks = this.fs.getFileBlockLocations(status, 0L, status.getLen());
        ImmutableRangeMap.Builder<Long, BlockLocation> blockMapBuilder = new ImmutableRangeMap.Builder<Long, BlockLocation>();
        for (BlockLocation block : blocks) {
            long start = block.getOffset();
            long end = start + block.getLength();
            Range<Long> range = Range.closedOpen(start, end);
            blockMapBuilder = blockMapBuilder.put(range, block);
        }
        ImmutableRangeMap<Long, BlockLocation> blockMap = blockMapBuilder.build();
        this.blockMapMap.put(status.getPath(), blockMap);
        context.stop();
        return blockMap;
    }

    private ImmutableRangeMap<Long, BlockLocation> getBlockMap(Path path) throws IOException {
        ImmutableRangeMap<Long, BlockLocation> blockMap = this.blockMapMap.get(path);
        if (blockMap == null) {
            blockMap = this.buildBlockMap(path);
        }
        return blockMap;
    }

    private ImmutableRangeMap<Long, BlockLocation> getBlockMap(FileStatus status) throws IOException {
        ImmutableRangeMap<Long, BlockLocation> blockMap = this.blockMapMap.get(status.getPath());
        if (blockMap == null) {
            blockMap = this.buildBlockMap(status);
        }
        return blockMap;
    }

    public EndpointByteMap getEndpointByteMap(Set<String> noDrillbitHosts, FileWork work) throws IOException {
        Stopwatch watch = Stopwatch.createStarted();
        Path fileName = work.getPath();
        ImmutableRangeMap<Long, BlockLocation> blockMap = this.getBlockMap(fileName);
        EndpointByteMapImpl endpointByteMap = new EndpointByteMapImpl();
        long start = work.getStart();
        long end = start + work.getLength();
        Range<Long> rowGroupRange = Range.closedOpen(start, end);
        RangeMap subRangeMap = blockMap.subRangeMap((Range)rowGroupRange);
        for (Map.Entry block : ((ImmutableMap)((ImmutableRangeMap)subRangeMap).asMapOfRanges()).entrySet()) {
            String[] hosts;
            Range blockRange = (Range)block.getKey();
            try {
                hosts = ((BlockLocation)block.getValue()).getHosts();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to get hosts for block location", ioe);
            }
            Range<Long> intersection = rowGroupRange.intersection(blockRange);
            long bytes = intersection.upperEndpoint() - intersection.lowerEndpoint();
            for (String host : hosts) {
                CoordinationProtos.DrillbitEndpoint endpoint = this.getDrillBitEndpoint(host);
                if (endpoint != null) {
                    endpointByteMap.add(endpoint, bytes);
                    continue;
                }
                if (noDrillbitHosts == null) continue;
                noDrillbitHosts.add(host);
            }
        }
        logger.debug("FileWork group ({},{}) max bytes {}", new Object[]{work.getPath(), work.getStart(), endpointByteMap.getMaxBytes()});
        logger.debug("Took {} ms to set endpoint bytes", (Object)watch.stop().elapsed(TimeUnit.MILLISECONDS));
        return endpointByteMap;
    }

    private CoordinationProtos.DrillbitEndpoint getDrillBitEndpoint(String hostName) {
        return this.endPointMap.get(hostName);
    }

    private static ImmutableMap<String, CoordinationProtos.DrillbitEndpoint> buildEndpointMap(Collection<CoordinationProtos.DrillbitEndpoint> endpoints) {
        Stopwatch watch = Stopwatch.createStarted();
        HashMap<String, CoordinationProtos.DrillbitEndpoint> endpointMap = Maps.newHashMap();
        for (CoordinationProtos.DrillbitEndpoint d : endpoints) {
            String hostName = d.getAddress();
            endpointMap.put(hostName, d);
        }
        watch.stop();
        logger.debug("Took {} ms to build endpoint map", (Object)watch.elapsed(TimeUnit.MILLISECONDS));
        return ImmutableMap.copyOf(endpointMap);
    }

    private class BlockMapReader
    extends TimedCallable<List<CompleteFileWork>> {
        final FileStatus status;
        final boolean blockify;

        public BlockMapReader(FileStatus status, boolean blockify) {
            this.status = status;
            this.blockify = blockify;
        }

        @Override
        protected List<CompleteFileWork> runInner() throws Exception {
            ArrayList<CompleteFileWork> work = new ArrayList<CompleteFileWork>();
            HashSet<String> noDrillbitHosts = logger.isDebugEnabled() ? new HashSet<String>() : null;
            boolean error = false;
            if (this.blockify && !BlockMapBuilder.this.compressed(this.status)) {
                try {
                    ImmutableRangeMap rangeMap = BlockMapBuilder.this.getBlockMap(this.status);
                    for (Map.Entry l : ((ImmutableMap)rangeMap.asMapOfRanges()).entrySet()) {
                        work.add(new CompleteFileWork(BlockMapBuilder.this.getEndpointByteMap(noDrillbitHosts, new FileStatusWork(this.status)), ((BlockLocation)l.getValue()).getOffset(), ((BlockLocation)l.getValue()).getLength(), this.status.getPath()));
                    }
                }
                catch (IOException e) {
                    logger.warn("failure while generating file work.", (Throwable)e);
                    error = true;
                }
            }
            if (!this.blockify || error || BlockMapBuilder.this.compressed(this.status)) {
                work.add(new CompleteFileWork(BlockMapBuilder.this.getEndpointByteMap(noDrillbitHosts, new FileStatusWork(this.status)), 0L, this.status.getLen(), this.status.getPath()));
            }
            if (work.isEmpty()) {
                work.add(new CompleteFileWork(BlockMapBuilder.this.getEndpointByteMap(noDrillbitHosts, new FileStatusWork(this.status)), 0L, 0L, this.status.getPath()));
            }
            if (noDrillbitHosts != null) {
                for (String host : noDrillbitHosts) {
                    logger.debug("Failure finding Drillbit running on host {}. Skipping affinity to that host.", (Object)host);
                }
            }
            return work;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("path", (Object)this.status.getPath()).toString();
        }
    }

    private class FileStatusWork
    implements FileWork {
        private FileStatus status;

        public FileStatusWork(FileStatus status) {
            Preconditions.checkArgument(!status.isDir(), "FileStatus work only works with files, not directories.");
            this.status = status;
        }

        @Override
        public Path getPath() {
            return this.status.getPath();
        }

        @Override
        public long getStart() {
            return 0L;
        }

        @Override
        public long getLength() {
            return this.status.getLen();
        }
    }
}

