/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.security;

import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;

public class CredentialProviderUtils {
    public static CredentialsProvider getCredentialsProvider(String username, String password, CredentialsProvider credentialsProvider) {
        if (credentialsProvider != null) {
            return credentialsProvider;
        }
        ImmutableMap.Builder<String, String> mapBuilder = ImmutableMap.builder();
        if (username != null) {
            mapBuilder.put("username", username);
        }
        if (password != null) {
            mapBuilder.put("password", password);
        }
        return new PlainCredentialsProvider(mapBuilder.build());
    }

    public static CredentialsProvider getCredentialsProvider(String clientID, String clientSecret, String tokenURI, String username, String password, String proxyUsername, String proxyPassword, CredentialsProvider credentialsProvider) {
        if (credentialsProvider != null) {
            return credentialsProvider;
        }
        ImmutableMap.Builder<String, String> mapBuilder = ImmutableMap.builder();
        if (clientID != null) {
            mapBuilder.put("clientID", clientID);
        }
        if (clientSecret != null) {
            mapBuilder.put("clientSecret", clientSecret);
        }
        if (username != null) {
            mapBuilder.put("username", username);
        }
        if (password != null) {
            mapBuilder.put("password", password);
        }
        if (tokenURI != null) {
            mapBuilder.put("tokenURI", tokenURI);
        }
        if (proxyUsername != null) {
            mapBuilder.put("proxyUsername", proxyUsername);
        }
        if (proxyPassword != null) {
            mapBuilder.put("proxyPassword", proxyPassword);
        }
        return new PlainCredentialsProvider(mapBuilder.build());
    }
}

