/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.hadoop.conf.Configuration;

public class HadoopCredentialsProvider
implements CredentialsProvider {
    private final Configuration configuration;
    private final Map<String, String> propertyNames;

    public HadoopCredentialsProvider(Configuration configuration, Map<String, String> propertyNames) {
        this.configuration = configuration;
        this.propertyNames = propertyNames;
    }

    @JsonCreator
    public HadoopCredentialsProvider(@JsonProperty(value="propertyNames") Map<String, String> propertyNames) {
        this.configuration = new Configuration();
        this.propertyNames = propertyNames;
    }

    @Override
    public Map<String, String> getCredentials() {
        HashMap<String, String> credentials = new HashMap<String, String>();
        this.propertyNames.forEach((key, value) -> {
            try {
                char[] credValue = this.configuration.getPassword(value);
                if (credValue != null) {
                    credentials.put((String)key, new String(credValue));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error while fetching credentials from configuration", e);
            }
        });
        return credentials;
    }

    public Map<String, String> getPropertyNames() {
        return this.propertyNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HadoopCredentialsProvider that = (HadoopCredentialsProvider)o;
        return Objects.equals(this.propertyNames, that.propertyNames);
    }

    public int hashCode() {
        return Objects.hash(this.propertyNames);
    }
}

