/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.security;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.logical.security.CredentialsProvider;

public class UsernamePasswordCredentials {
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    private final String username;
    private final String password;

    public UsernamePasswordCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsernamePasswordCredentials that = (UsernamePasswordCredentials)o;
        return Objects.equals(this.username, that.password) && Objects.equals(this.password, that.password);
    }

    public String toString() {
        return new PlanStringBuilder(this).field(USERNAME, this.username).maskedField(PASSWORD, this.password).toString();
    }

    public static class Builder {
        private CredentialsProvider credentialsProvider;
        private String queryUser;

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder setQueryUser(String queryUser) {
            this.queryUser = queryUser;
            return this;
        }

        public Optional<UsernamePasswordCredentials> build() {
            Map<String, String> credentials;
            if (this.credentialsProvider == null) {
                return Optional.empty();
            }
            Map<String, String> map = credentials = this.queryUser != null ? this.credentialsProvider.getUserCredentials(this.queryUser) : this.credentialsProvider.getCredentials();
            if (credentials.size() == 0) {
                return Optional.empty();
            }
            return Optional.of(new UsernamePasswordCredentials(credentials.get(UsernamePasswordCredentials.USERNAME), credentials.get(UsernamePasswordCredentials.PASSWORD)));
        }
    }
}

