/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import java.sql.Timestamp;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.rest.profile.SimpleDurationFormat;
import org.apache.drill.exec.store.pojo.NonNullable;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitToUserConnectionIterator
implements Iterator<Object> {
    static final Logger logger = LoggerFactory.getLogger(BitToUserConnectionIterator.class);
    Iterator<ConnectionInfo> itr;
    private String queryingUsername;
    private boolean isAdmin;

    public BitToUserConnectionIterator(ExecutorFragmentContext context) {
        this.queryingUsername = context.getQueryUserName();
        this.isAdmin = this.hasAdminPrivileges(context);
        this.itr = this.iterateConnectionInfo(context);
    }

    private boolean hasAdminPrivileges(ExecutorFragmentContext context) {
        OptionManager options = context.getOptions();
        return !context.isUserAuthenticationEnabled() || ImpersonationUtil.hasAdminPrivileges(this.queryingUsername, ExecConstants.ADMIN_USERS_VALIDATOR.getAdminUsers(options), ExecConstants.ADMIN_USER_GROUPS_VALIDATOR.getAdminUserGroups(options));
    }

    private Iterator<ConnectionInfo> iterateConnectionInfo(ExecutorFragmentContext context) {
        Set<Map.Entry<UserServer.BitToUserConnection, UserServer.BitToUserConnectionConfig>> activeConnections = context.getUserConnections();
        String hostname = context.getEndpoint().getAddress();
        LinkedList<ConnectionInfo> connectionInfos = new LinkedList<ConnectionInfo>();
        for (Map.Entry<UserServer.BitToUserConnection, UserServer.BitToUserConnectionConfig> connection : activeConnections) {
            if (!this.isAdmin && !this.queryingUsername.equals(connection.getKey().getSession().getTargetUserName())) continue;
            connectionInfos.add(new ConnectionInfo(connection, hostname));
        }
        return connectionInfos.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.itr.hasNext();
    }

    @Override
    public Object next() {
        return this.itr.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class ConnectionInfo {
        public String user;
        @NonNullable
        public String client;
        @NonNullable
        public String drillbit;
        @NonNullable
        public Timestamp established;
        public String duration;
        public int queries;
        public boolean isAuthenticated;
        public boolean isEncrypted;
        public boolean usingSSL;
        @NonNullable
        public String session;

        public ConnectionInfo(Map.Entry<UserServer.BitToUserConnection, UserServer.BitToUserConnectionConfig> connectionConfigPair, String hostname) {
            UserServer.BitToUserConnection connection = connectionConfigPair.getKey();
            UserServer.BitToUserConnectionConfig config = connectionConfigPair.getValue();
            UserSession userSession = connection.getSession();
            this.user = userSession.getCredentials().getUserName();
            DateTime dateTime = config.getEstablished();
            this.established = new Timestamp(dateTime.plusMillis(TimeZone.getDefault().getOffset(dateTime.getMillis())).getMillis());
            this.duration = new SimpleDurationFormat(dateTime.getMillis(), System.currentTimeMillis()).verbose();
            this.client = this.extractIpAddr(connection.getRemoteAddress().toString());
            this.drillbit = hostname;
            this.session = userSession.getSessionId();
            this.queries = userSession.getQueryCount();
            this.isAuthenticated = config.isAuthEnabled();
            this.isEncrypted = config.isEncryptionEnabled();
            this.usingSSL = config.isSSLEnabled();
        }

        private String extractIpAddr(String clientAddrString) {
            String ipAddr = clientAddrString.replaceFirst("/", "").split(":")[0];
            return ipAddr;
        }
    }
}

