/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import java.util.Iterator;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.pojo.NonNullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillbitIterator
implements Iterator<Object> {
    static final Logger logger = LoggerFactory.getLogger(DrillbitIterator.class);
    private Iterator<CoordinationProtos.DrillbitEndpoint> endpoints;
    private CoordinationProtos.DrillbitEndpoint current;

    public DrillbitIterator(ExecutorFragmentContext c) {
        this.endpoints = c.getBits().iterator();
        this.current = c.getEndpoint();
    }

    @Override
    public boolean hasNext() {
        return this.endpoints.hasNext();
    }

    @Override
    public Object next() {
        CoordinationProtos.DrillbitEndpoint ep = this.endpoints.next();
        DrillbitInstance i = new DrillbitInstance();
        i.current = this.isCurrent(ep);
        i.hostname = ep.getAddress();
        i.http_port = ep.getHttpPort();
        i.user_port = ep.getUserPort();
        i.control_port = ep.getControlPort();
        i.data_port = ep.getDataPort();
        i.version = ep.getVersion();
        i.state = ep.getState().toString();
        return i;
    }

    public boolean isCurrent(CoordinationProtos.DrillbitEndpoint ep) {
        String epAddress = ep.getAddress();
        int epPort = ep.getUserPort();
        String currentEpAddress = this.current.getAddress();
        int currentEpPort = this.current.getUserPort();
        return currentEpAddress.equals(epAddress) && currentEpPort == epPort;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class DrillbitInstance {
        @NonNullable
        public String hostname;
        public int user_port;
        public int control_port;
        public int data_port;
        public int http_port;
        @NonNullable
        public boolean current;
        @NonNullable
        public String version;
        @NonNullable
        public String state;
    }
}

