/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.Message;
import io.protostuff.Schema;
import org.apache.drill.exec.serialization.InstanceSerializer;
import org.apache.drill.exec.serialization.JacksonSerializer;
import org.apache.drill.exec.serialization.ProtoSerializer;
import org.apache.drill.exec.store.sys.PersistentStoreMode;
import org.apache.drill.shaded.guava.com.google.common.base.Objects;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class PersistentStoreConfig<V> {
    private final String name;
    private final InstanceSerializer<V> valueSerializer;
    private final PersistentStoreMode mode;
    private final int capacity;

    protected PersistentStoreConfig(String name, InstanceSerializer<V> valueSerializer, PersistentStoreMode mode, int capacity) {
        this.name = name;
        this.valueSerializer = valueSerializer;
        this.mode = mode;
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public PersistentStoreMode getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public InstanceSerializer<V> getSerializer() {
        return this.valueSerializer;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.name, this.valueSerializer, this.mode});
    }

    public boolean equals(Object obj) {
        if (obj instanceof PersistentStoreConfig) {
            PersistentStoreConfig other = (PersistentStoreConfig)PersistentStoreConfig.class.cast(obj);
            return Objects.equal(this.name, other.name) && Objects.equal(this.valueSerializer, other.valueSerializer) && Objects.equal((Object)this.mode, (Object)other.mode);
        }
        return false;
    }

    public static <V extends Message, X extends Message.Builder> StoreConfigBuilder<V> newProtoBuilder(Schema<V> writeSchema, Schema<X> readSchema) {
        return new StoreConfigBuilder(new ProtoSerializer<V, X>(readSchema, writeSchema));
    }

    public static <V> StoreConfigBuilder<V> newJacksonBuilder(Class<V> clazz) {
        return new StoreConfigBuilder<V>(new JacksonSerializer<V>(clazz));
    }

    public static <V> StoreConfigBuilder<V> newJacksonBuilder(ObjectMapper mapper, Class<V> clazz) {
        return new StoreConfigBuilder<V>(new JacksonSerializer<V>(mapper, clazz));
    }

    public static class StoreConfigBuilder<V> {
        private String name;
        private InstanceSerializer<V> serializer;
        private PersistentStoreMode mode = PersistentStoreMode.PERSISTENT;
        private int capacity;

        protected StoreConfigBuilder(InstanceSerializer<V> serializer) {
            this.serializer = serializer;
        }

        public StoreConfigBuilder<V> name(String name) {
            this.name = name;
            return this;
        }

        public StoreConfigBuilder<V> persist() {
            this.mode = PersistentStoreMode.PERSISTENT;
            return this;
        }

        public StoreConfigBuilder<V> blob() {
            this.mode = PersistentStoreMode.BLOB_PERSISTENT;
            return this;
        }

        public StoreConfigBuilder<V> setCapacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public PersistentStoreConfig<V> build() {
            Preconditions.checkNotNull(this.name);
            return new PersistentStoreConfig<V>(this.name, this.serializer, this.mode, this.capacity);
        }
    }
}

