/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.store.pojo.NonNullable;
import org.apache.drill.exec.store.sys.ProfileIterator;
import org.apache.drill.shaded.guava.com.google.common.base.Function;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileInfoIterator
extends ProfileIterator {
    static final Logger logger = LoggerFactory.getLogger(ProfileInfoIterator.class);
    private final Iterator<ProfileInfo> itr = this.iterateProfileInfo();

    public ProfileInfoIterator(ExecutorFragmentContext context, int maxRecords) {
        super(context, maxRecords);
    }

    @Override
    protected Iterator<Map.Entry<String, UserBitShared.QueryProfile>> getProfiles(int skip, int take) {
        return this.profileStoreContext.getCompletedProfileStore().getRange(skip, take);
    }

    private Iterator<ProfileInfo> iterateProfileInfo() {
        try {
            return this.transform(this.getAuthorizedProfiles(this.queryingUsername, this.isAdmin));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Iterators.singletonIterator(ProfileInfo.getDefault());
        }
    }

    private Iterator<ProfileInfo> transform(Iterator<Map.Entry<String, UserBitShared.QueryProfile>> all) {
        return Iterators.transform(all, new Function<Map.Entry<String, UserBitShared.QueryProfile>, ProfileInfo>(){

            @Override
            @Nullable
            public ProfileInfo apply(@Nullable Map.Entry<String, UserBitShared.QueryProfile> input) {
                if (input == null || input.getValue() == null) {
                    return ProfileInfo.getDefault();
                }
                String queryID = input.getKey();
                UserBitShared.QueryProfile profile = input.getValue();
                long assumedQueueEndTime = profile.getQueueWaitEnd() > 0L ? profile.getQueueWaitEnd() : profile.getPlanEnd();
                return new ProfileInfo(queryID, new Timestamp(profile.getStart()), profile.getForeman().getAddress(), profile.getTotalFragments(), profile.getUser(), profile.getQueueName(), ProfileInfoIterator.this.computeDuration(profile.getStart(), profile.getPlanEnd()), ProfileInfoIterator.this.computeDuration(profile.getPlanEnd(), assumedQueueEndTime), ProfileInfoIterator.this.computeDuration(assumedQueueEndTime, profile.getEnd()), profile.getState().name(), profile.getScannedPluginsCount(), profile.getScannedPluginsList().toString(), profile.getQuery());
            }
        });
    }

    @Override
    public boolean hasNext() {
        return this.itr.hasNext();
    }

    @Override
    public Object next() {
        return this.itr.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class ProfileInfo {
        private static final String UNKNOWN_VALUE = "N/A";
        private static final ProfileInfo DEFAULT = new ProfileInfo();
        @NonNullable
        public final String queryId;
        public final Timestamp startTime;
        @NonNullable
        public final String foreman;
        public final long fragments;
        public final String user;
        public final String queue;
        public final long planTime;
        public final long queueTime;
        public final long executeTime;
        public final long totalTime;
        public final String state;
        public final long pluginCount;
        public final String pluginList;
        public final String query;

        public ProfileInfo(String query_id, Timestamp time, String foreman, long fragmentCount, String username, String queueName, long planDuration, long queueWaitDuration, long executeDuration, String state, long pluginCount, String pluginList, String query) {
            this.queryId = query_id;
            this.startTime = time;
            this.foreman = foreman;
            this.fragments = fragmentCount;
            this.user = username;
            this.queue = queueName;
            this.planTime = planDuration;
            this.queueTime = queueWaitDuration;
            this.executeTime = executeDuration;
            this.totalTime = this.planTime + this.queueTime + this.executeTime;
            this.query = query;
            this.pluginCount = pluginCount;
            this.pluginList = pluginList;
            this.state = state;
        }

        private ProfileInfo() {
            this(UNKNOWN_VALUE, new Timestamp(0L), UNKNOWN_VALUE, 0L, UNKNOWN_VALUE, UNKNOWN_VALUE, 0L, 0L, 0L, UNKNOWN_VALUE, 0L, UNKNOWN_VALUE, UNKNOWN_VALUE);
        }

        public static ProfileInfo getDefault() {
            return DEFAULT;
        }
    }
}

