/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.SystemPlugin;
import org.apache.drill.exec.store.pojo.PojoDataType;
import org.apache.drill.exec.store.sys.StaticDrillTable;
import org.apache.drill.exec.store.sys.SystemTable;
import org.apache.drill.exec.store.sys.SystemTablePluginConfig;
import org.apache.drill.exec.store.sys.SystemTableScan;

@SystemPlugin
public class SystemTablePlugin
extends AbstractStoragePlugin {
    public static final String SYS_SCHEMA_NAME = "sys";
    private final SystemTablePluginConfig config;
    private final SystemSchema schema;

    public SystemTablePlugin(DrillbitContext context) {
        this(SystemTablePluginConfig.INSTANCE, context, SYS_SCHEMA_NAME);
    }

    public SystemTablePlugin(SystemTablePluginConfig config, DrillbitContext context, String name) {
        super(context, name);
        this.config = config;
        this.schema = new SystemSchema(this);
    }

    @Override
    public StoragePluginConfig getConfig() {
        return this.config;
    }

    @Override
    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) {
        parent.add(this.schema.getName(), (Schema)this.schema);
    }

    @Override
    public AbstractGroupScan getPhysicalScan(String userName, JSONOptions selection, List<SchemaPath> columns) {
        SystemTable table = selection.getWith(this.getContext().getLpPersistence().getMapper(), SystemTable.class);
        return new SystemTableScan(table, this);
    }

    private class SystemSchema
    extends AbstractSchema {
        private final Map<String, StaticDrillTable> tables;

        SystemSchema(SystemTablePlugin plugin) {
            super(Collections.emptyList(), SystemTablePlugin.SYS_SCHEMA_NAME);
            this.tables = Arrays.stream(SystemTable.values()).collect(Collectors.toMap(SystemTable::getTableName, table -> new StaticDrillTable(this.getName(), (StoragePlugin)plugin, Schema.TableType.SYSTEM_TABLE, (DrillTableSelection)table, new PojoDataType(table.getPojoClass())), (o, n) -> n, CaseInsensitiveMap::newHashMap));
        }

        @Override
        public Set<String> getTableNames() {
            return this.tables.keySet();
        }

        @Override
        public DrillTable getTable(String name) {
            return this.tables.get(name);
        }

        @Override
        public String getTypeName() {
            return "system-tables";
        }

        @Override
        public boolean areTableNamesCaseSensitive() {
            return false;
        }
    }
}

