/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.planner.fragment.DistributionAffinity;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.sys.SystemTable;
import org.apache.drill.exec.store.sys.SystemTablePlugin;
import org.apache.drill.exec.store.sys.SystemTablePluginConfig;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

@JsonTypeName(value="sys")
public class SystemTableScan
extends AbstractGroupScan
implements SubScan {
    public static final String OPERATOR_TYPE = "SYSTEM_TABLE_SCAN";
    private final SystemTable table;
    private final SystemTablePlugin plugin;
    private final int maxRecordsToRead;

    @JsonCreator
    public SystemTableScan(@JsonProperty(value="table") SystemTable table, @JsonProperty(value="maxRecordsToRead") int maxRecordsToRead, @JacksonInject StoragePluginRegistry engineRegistry) throws ExecutionSetupException {
        this(table, maxRecordsToRead, engineRegistry.resolve(SystemTablePluginConfig.INSTANCE, SystemTablePlugin.class));
    }

    public SystemTableScan(SystemTable table, SystemTablePlugin plugin) {
        this(table, Integer.MAX_VALUE, plugin);
    }

    public SystemTableScan(SystemTable table, int maxRecordsToRead, SystemTablePlugin plugin) {
        super((String)null);
        this.table = table;
        this.maxRecordsToRead = maxRecordsToRead;
        this.plugin = plugin;
    }

    @Override
    public ScanStats getScanStats() {
        return ScanStats.TRIVIAL_TABLE;
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        return new SystemTableScan(this.table, this.maxRecordsToRead, this.plugin);
    }

    @Override
    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) {
    }

    @Override
    @JsonIgnore
    public List<SchemaPath> getColumns() {
        return super.getColumns();
    }

    @Override
    public SubScan getSpecificScan(int minorFragmentId) {
        return this;
    }

    @Override
    public int getMaxParallelizationWidth() {
        return this.table.isDistributed() ? this.plugin.getContext().getBits().size() : 1;
    }

    @Override
    public int getMinParallelizationWidth() {
        return this.table.isDistributed() ? this.plugin.getContext().getBits().size() : 1;
    }

    @Override
    public long getInitialAllocation() {
        return this.initialAllocation;
    }

    @Override
    public long getMaxAllocation() {
        return this.maxAllocation;
    }

    @Override
    public String getDigest() {
        StringBuilder builder = new StringBuilder();
        builder.append("SystemTableScan [");
        builder.append("table=").append(this.table.name()).append(", ");
        builder.append("distributed=").append(this.table.isDistributed());
        if (this.maxRecordsToRead != Integer.MAX_VALUE) {
            builder.append(", maxRecordsToRead=").append(this.maxRecordsToRead);
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    @Override
    public List<EndpointAffinity> getOperatorAffinity() {
        if (this.table.isDistributed()) {
            ArrayList<EndpointAffinity> affinities = Lists.newArrayList();
            Collection<CoordinationProtos.DrillbitEndpoint> bits = this.plugin.getContext().getBits();
            double affinityPerNode = 1.0 / (double)bits.size();
            for (CoordinationProtos.DrillbitEndpoint endpoint : bits) {
                affinities.add(new EndpointAffinity(endpoint, affinityPerNode, true, 1));
            }
            return affinities;
        }
        return Collections.emptyList();
    }

    @Override
    public DistributionAffinity getDistributionAffinity() {
        return this.table.isDistributed() ? DistributionAffinity.HARD : DistributionAffinity.SOFT;
    }

    @Override
    public GroupScan clone(List<SchemaPath> columns) {
        return this;
    }

    public GroupScan clone(SystemTableScan systemTableScan, int maxRecordsToRead) {
        return new SystemTableScan(systemTableScan.getTable(), maxRecordsToRead, systemTableScan.getPlugin());
    }

    @Override
    public boolean supportsLimitPushdown() {
        return true;
    }

    @Override
    public GroupScan applyLimit(int maxRecords) {
        if (this.maxRecordsToRead == maxRecords) {
            return null;
        }
        return this.clone(this, maxRecords);
    }

    public SystemTable getTable() {
        return this.table;
    }

    public int getMaxRecordsToRead() {
        return this.maxRecordsToRead;
    }

    @JsonIgnore
    public SystemTablePlugin getPlugin() {
        return this.plugin;
    }
}

