/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys.store;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.exec.store.sys.BasePersistentStore;
import org.apache.drill.exec.store.sys.PersistentStoreMode;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterables;

public class InMemoryStore<V>
extends BasePersistentStore<V> {
    private final ConcurrentNavigableMap<String, V> store;
    private final int capacity;
    private final AtomicInteger currentSize = new AtomicInteger();

    public InMemoryStore(int capacity) {
        this.capacity = capacity;
        this.store = new ConcurrentSkipListMap<String, V>();
    }

    @Override
    public void delete(String key) {
        this.store.remove(key);
    }

    @Override
    public PersistentStoreMode getMode() {
        return PersistentStoreMode.BLOB_PERSISTENT;
    }

    @Override
    public boolean contains(String key) {
        return this.store.containsKey(key);
    }

    @Override
    public V get(String key) {
        return this.store.get(key);
    }

    @Override
    public void put(String key, V value) {
        this.store.put(key, value);
        if (this.currentSize.incrementAndGet() > this.capacity) {
            this.store.pollLastEntry();
            this.currentSize.decrementAndGet();
        }
    }

    @Override
    public boolean putIfAbsent(String key, V value) {
        return value != this.store.putIfAbsent(key, value);
    }

    @Override
    public Iterator<Map.Entry<String, V>> getRange(int skip, int take) {
        return Iterables.limit(Iterables.skip(this.store.entrySet(), skip), take).iterator();
    }

    @Override
    public void close() {
        this.store.clear();
    }
}

