/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys.store;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.sys.BasePersistentStore;
import org.apache.drill.exec.store.sys.PersistentStoreConfig;
import org.apache.drill.exec.store.sys.PersistentStoreMode;
import org.apache.drill.exec.util.DrillFileSystemUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPersistentStore<V>
extends BasePersistentStore<V> {
    private static final Logger logger = LoggerFactory.getLogger(LocalPersistentStore.class);
    private static final PathFilter SYS_FILE_SUFFIX_FILTER = path -> path.getName().endsWith(".sys.drill");
    private final Path basePath;
    private final PersistentStoreConfig<V> config;
    private final DrillFileSystem fs;

    public LocalPersistentStore(DrillFileSystem fs, Path base, PersistentStoreConfig<V> config) {
        this.basePath = new Path(base, config.getName());
        this.config = config;
        this.fs = fs;
        try {
            fs.mkdirs(this.basePath);
        }
        catch (IOException e) {
            throw DrillRuntimeException.create(e, "Failure setting local persistent store path [%s]: %s", this.basePath, e.getMessage());
        }
    }

    @Override
    public PersistentStoreMode getMode() {
        return PersistentStoreMode.PERSISTENT;
    }

    public static Path getLogDir() {
        String drillLogDir = System.getenv("DRILL_LOG_DIR");
        if (drillLogDir == null) {
            drillLogDir = System.getProperty("drill.log.dir");
        }
        if (drillLogDir == null) {
            drillLogDir = "/var/log/drill";
        }
        return new Path(new File(drillLogDir).getAbsoluteFile().toURI());
    }

    public static DrillFileSystem getFileSystem(DrillConfig config, Path root) throws IOException {
        Path blobRoot = root == null ? LocalPersistentStore.getLogDir() : root;
        Configuration fsConf = new Configuration();
        if (blobRoot.toUri().getScheme() != null) {
            fsConf.set("fs.defaultFS", blobRoot.toUri().toString());
        }
        DrillFileSystem fs = new DrillFileSystem(fsConf);
        fs.mkdirs(blobRoot);
        return fs;
    }

    @Override
    public Iterator<Map.Entry<String, V>> getRange(int skip, int take) {
        List<FileStatus> fileStatuses;
        try {
            fileStatuses = DrillFileSystemUtil.listFiles(this.fs, this.basePath, false, SYS_FILE_SUFFIX_FILTER);
        }
        catch (IOException e) {
            throw DrillRuntimeException.create(e, "Unable to retrieve store data: %s", e.getMessage());
        }
        if (fileStatuses.isEmpty()) {
            return Collections.emptyIterator();
        }
        return fileStatuses.stream().map(this::extractKeyName).sorted().skip(skip).limit(take).collect(Collectors.toMap(Function.identity(), this::get, (o, n) -> n, LinkedHashMap::new)).entrySet().iterator();
    }

    @Override
    public boolean contains(String key) {
        Path path = this.makePath(key, false);
        return this.exists(path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V get(String key) {
        Path path = this.makePath(key, false);
        if (!this.exists(path)) {
            return null;
        }
        try (FSDataInputStream is = this.fs.open(path);){
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            V v = this.deserialize(path, bytes);
            return v;
        }
        catch (IOException e) {
            throw DrillRuntimeException.create(e, "Unable to retrieve store data for the path [%s]: %s", path, e.getMessage());
        }
    }

    @Override
    public void put(String key, V value) {
        Path path = this.makePath(key, true);
        this.put(path, value);
    }

    @Override
    public boolean putIfAbsent(String key, V value) {
        Path path = this.makePath(key, true);
        if (this.exists(path)) {
            return false;
        }
        this.put(path, value);
        return true;
    }

    @Override
    public void delete(String key) {
        Path path = this.makePath(key, true);
        try {
            this.fs.delete(path, false);
        }
        catch (IOException e) {
            throw DrillRuntimeException.create(e, "Unable to delete store data for the path [%s]: %s", path, e.getMessage());
        }
    }

    @Override
    public void close() {
    }

    private boolean isValidKey(String key) {
        return key != null && !key.isEmpty() && !key.contains(":") && !key.contains("..") && !key.contains("/");
    }

    private Path makePath(String key, boolean failOnInvalidKey) {
        if (this.isValidKey(key)) {
            try {
                return new Path(this.basePath, key + ".sys.drill");
            }
            catch (IllegalArgumentException e) {
                return this.handleInvalidKey(key, e, failOnInvalidKey);
            }
        }
        return this.handleInvalidKey(key, null, failOnInvalidKey);
    }

    private Path handleInvalidKey(String key, Throwable throwable, boolean failOnInvalidKey) {
        if (failOnInvalidKey) {
            throw DrillRuntimeException.create(throwable, "Illegal storage key name: %s", key);
        }
        logger.debug("Illegal storage key name: {}", (Object)key, (Object)throwable);
        return null;
    }

    private boolean exists(Path path) {
        try {
            return path != null && this.fs.exists(path);
        }
        catch (IOException e) {
            throw DrillRuntimeException.create(e, "Unable to check store file [%s] existence: %s", path, e.getMessage());
        }
    }

    private byte[] serialize(Path path, V value) {
        try {
            return this.config.getSerializer().serialize(value);
        }
        catch (IOException e) {
            throw DrillRuntimeException.create(e, "Unable serialize value for the store key [%s]: %s", path, e.getMessage());
        }
    }

    private V deserialize(Path path, byte[] bytes) {
        try {
            return this.config.getSerializer().deserialize(bytes);
        }
        catch (IOException e) {
            throw DrillRuntimeException.create(e, "Unable deserialize value for the path [%s]: %s", path, e.getMessage());
        }
    }

    private void put(Path path, V value) {
        try (FSDataOutputStream os = this.fs.create(path);){
            IOUtils.write((byte[])this.serialize(path, value), (OutputStream)os);
        }
        catch (IOException e) {
            throw DrillRuntimeException.create(e, "Unable to store data for the path [%s]: %s", path, e.getMessage());
        }
    }

    private String extractKeyName(FileStatus fileStatus) {
        String name = fileStatus.getPath().getName();
        return name.substring(0, name.length() - ".sys.drill".length());
    }
}

