/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys.store;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.concurrent.AutoCloseableLock;
import org.apache.drill.exec.exception.VersionMismatchException;
import org.apache.drill.exec.store.sys.PersistentStore;
import org.apache.drill.exec.store.sys.PersistentStoreMode;
import org.apache.drill.exec.store.sys.VersionedPersistentStore;
import org.apache.drill.exec.store.sys.store.DataChangeVersion;

public class VersionedDelegatingStore<V>
implements VersionedPersistentStore<V> {
    private final PersistentStore<V> store;
    private final AutoCloseableLock readLock;
    private final AutoCloseableLock writeLock;
    private int version;

    public VersionedDelegatingStore(PersistentStore<V> store) {
        this.store = store;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = new AutoCloseableLock(readWriteLock.readLock());
        this.writeLock = new AutoCloseableLock(readWriteLock.writeLock());
        this.version = 0;
    }

    @Override
    public PersistentStoreMode getMode() {
        return this.store.getMode();
    }

    @Override
    public void delete(String key) {
        try (AutoCloseables.Closeable lock = this.writeLock.open();){
            this.store.delete(key);
            ++this.version;
        }
    }

    @Override
    public boolean contains(String key, DataChangeVersion dataChangeVersion) {
        try (AutoCloseables.Closeable lock = this.readLock.open();){
            boolean contains = this.store.contains(key);
            dataChangeVersion.setVersion(this.version);
            boolean bl = contains;
            return bl;
        }
    }

    @Override
    public V get(String key, DataChangeVersion dataChangeVersion) {
        try (AutoCloseables.Closeable lock = this.readLock.open();){
            V value = this.store.get(key);
            dataChangeVersion.setVersion(this.version);
            V v = value;
            return v;
        }
    }

    @Override
    public void put(String key, V value, DataChangeVersion dataChangeVersion) {
        try (AutoCloseables.Closeable lock = this.writeLock.open();){
            if (dataChangeVersion.getVersion() != this.version) {
                throw new VersionMismatchException("Version mismatch detected", dataChangeVersion.getVersion());
            }
            this.store.put(key, value);
            ++this.version;
        }
    }

    @Override
    public boolean putIfAbsent(String key, V value) {
        try (AutoCloseables.Closeable lock = this.writeLock.open();){
            if (this.store.putIfAbsent(key, value)) {
                ++this.version;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public Iterator<Map.Entry<String, V>> getRange(int skip, int take) {
        try (AutoCloseables.Closeable lock = this.readLock.open();){
            Iterator iterator = this.store.getRange(skip, take);
            return iterator;
        }
    }

    @Override
    public void close() throws Exception {
        try (AutoCloseables.Closeable lock = this.writeLock.open();){
            this.store.close();
            this.version = -1;
        }
    }
}

