/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys.store;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.drill.common.collections.ImmutableEntry;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.coord.zk.PathUtils;
import org.apache.drill.exec.coord.zk.ZookeeperClient;
import org.apache.drill.exec.exception.StoreException;
import org.apache.drill.exec.serialization.InstanceSerializer;
import org.apache.drill.exec.store.sys.BasePersistentStore;
import org.apache.drill.exec.store.sys.PersistentStoreConfig;
import org.apache.drill.exec.store.sys.PersistentStoreMode;
import org.apache.drill.exec.store.sys.VersionedPersistentStore;
import org.apache.drill.exec.store.sys.store.DataChangeVersion;
import org.apache.drill.shaded.guava.com.google.common.base.Function;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterators;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperPersistentStore<V>
extends BasePersistentStore<V>
implements VersionedPersistentStore<V> {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperPersistentStore.class);
    private final PersistentStoreConfig<V> config;
    private final ZookeeperClient client;

    public ZookeeperPersistentStore(CuratorFramework framework, PersistentStoreConfig<V> config) throws StoreException {
        this.config = Preconditions.checkNotNull(config);
        this.client = new ZookeeperClient(framework, PathUtils.join("/", config.getName()), CreateMode.PERSISTENT);
    }

    public void start() throws Exception {
        this.client.start();
    }

    @Override
    public PersistentStoreMode getMode() {
        return this.config.getMode();
    }

    @Override
    public boolean contains(String key) {
        return this.contains(key, null);
    }

    @Override
    public boolean contains(String key, DataChangeVersion version) {
        return this.client.hasPath(key, true, version);
    }

    @Override
    public V get(String key) {
        return this.get(key, false, null);
    }

    @Override
    public V get(String key, DataChangeVersion version) {
        return this.get(key, true, version);
    }

    public V get(String key, boolean consistencyFlag, DataChangeVersion version) {
        byte[] bytes = this.client.get(key, consistencyFlag, version);
        if (bytes == null) {
            return null;
        }
        try {
            return this.config.getSerializer().deserialize(bytes);
        }
        catch (IOException e) {
            throw new DrillRuntimeException(String.format("unable to deserialize value at %s", key), e);
        }
    }

    @Override
    public void put(String key, V value) {
        this.put(key, value, null);
    }

    @Override
    public void put(String key, V value, DataChangeVersion version) {
        InstanceSerializer<V> serializer = this.config.getSerializer();
        try {
            byte[] bytes = serializer.serialize(value);
            this.client.put(key, bytes, version);
        }
        catch (IOException e) {
            throw new DrillRuntimeException(String.format("unable to de/serialize value of type %s", value.getClass()), e);
        }
    }

    @Override
    public boolean putIfAbsent(String key, V value) {
        try {
            byte[] bytes = this.config.getSerializer().serialize(value);
            byte[] data = this.client.putIfAbsent(key, bytes);
            return data == null;
        }
        catch (IOException e) {
            throw new DrillRuntimeException(String.format("unable to serialize value of type %s", value.getClass()), e);
        }
    }

    @Override
    public void delete(String key) {
        this.client.delete(key);
    }

    @Override
    public Iterator<Map.Entry<String, V>> getRange(int skip, int take) {
        Iterator<Map.Entry<String, byte[]>> entries = this.client.entries();
        Iterators.advance(entries, skip);
        return Iterators.transform(Iterators.limit(entries, take), new Function<Map.Entry<String, byte[]>, Map.Entry<String, V>>(){

            @Override
            @Nullable
            public Map.Entry<String, V> apply(@Nullable Map.Entry<String, byte[]> input) {
                try {
                    Object value = ZookeeperPersistentStore.this.config.getSerializer().deserialize(input.getValue());
                    return new ImmutableEntry(input.getKey(), value);
                }
                catch (IOException e) {
                    throw new DrillRuntimeException(String.format("unable to deserialize value at key %s", input.getKey()), e);
                }
            }
        });
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (Exception e) {
            logger.warn("Failure while closing out {}: {}", (Object)this.getClass().getSimpleName(), (Object)e);
        }
    }
}

