/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys.store.provider;

import java.io.IOException;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.exception.StoreException;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.sys.PersistentStore;
import org.apache.drill.exec.store.sys.PersistentStoreConfig;
import org.apache.drill.exec.store.sys.PersistentStoreRegistry;
import org.apache.drill.exec.store.sys.VersionedPersistentStore;
import org.apache.drill.exec.store.sys.store.LocalPersistentStore;
import org.apache.drill.exec.store.sys.store.VersionedDelegatingStore;
import org.apache.drill.exec.store.sys.store.provider.BasePersistentStoreProvider;
import org.apache.drill.exec.testing.store.NoWriteLocalStore;
import org.apache.hadoop.fs.Path;

public class LocalPersistentStoreProvider
extends BasePersistentStoreProvider {
    private final Path path;
    private final DrillFileSystem fs;
    private final boolean enableWrite;

    public LocalPersistentStoreProvider(PersistentStoreRegistry<?> registry) throws StoreException {
        this(registry.getConfig());
    }

    public LocalPersistentStoreProvider(DrillConfig config) throws StoreException {
        this.path = new Path(config.getString("drill.exec.sys.store.provider.local.path"));
        this.enableWrite = config.getBoolean("drill.exec.sys.store.provider.local.write");
        try {
            this.fs = LocalPersistentStore.getFileSystem(config, this.path);
        }
        catch (IOException e) {
            throw new StoreException("unable to get filesystem", e);
        }
    }

    @Override
    public <V> PersistentStore<V> getOrCreateStore(PersistentStoreConfig<V> storeConfig) {
        switch (storeConfig.getMode()) {
            case BLOB_PERSISTENT: 
            case PERSISTENT: {
                if (this.enableWrite) {
                    return new LocalPersistentStore<V>(this.fs, this.path, storeConfig);
                }
                return new NoWriteLocalStore();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public <V> VersionedPersistentStore<V> getOrCreateVersionedStore(PersistentStoreConfig<V> config) {
        return new VersionedDelegatingStore<V>(this.getOrCreateStore(config));
    }

    @Override
    public void close() throws Exception {
        this.fs.close();
    }
}

