/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys.store.provider;

import java.io.IOException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.coord.zk.ZKClusterCoordinator;
import org.apache.drill.exec.exception.StoreException;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.sys.PersistentStore;
import org.apache.drill.exec.store.sys.PersistentStoreConfig;
import org.apache.drill.exec.store.sys.PersistentStoreRegistry;
import org.apache.drill.exec.store.sys.VersionedPersistentStore;
import org.apache.drill.exec.store.sys.store.LocalPersistentStore;
import org.apache.drill.exec.store.sys.store.VersionedDelegatingStore;
import org.apache.drill.exec.store.sys.store.ZookeeperPersistentStore;
import org.apache.drill.exec.store.sys.store.provider.BasePersistentStoreProvider;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.fs.Path;

public class ZookeeperPersistentStoreProvider
extends BasePersistentStoreProvider {
    public static final String DRILL_EXEC_SYS_STORE_PROVIDER_ZK_BLOBROOT = "drill.exec.sys.store.provider.zk.blobroot";
    private final CuratorFramework curator;
    private final DrillFileSystem fs;
    private final Path blobRoot;

    public ZookeeperPersistentStoreProvider(PersistentStoreRegistry<ZKClusterCoordinator> registry) throws StoreException {
        this(registry.getConfig(), registry.getCoordinator().getCurator());
    }

    @VisibleForTesting
    public ZookeeperPersistentStoreProvider(DrillConfig config, CuratorFramework curator) throws StoreException {
        this.curator = curator;
        this.blobRoot = config.hasPath(DRILL_EXEC_SYS_STORE_PROVIDER_ZK_BLOBROOT) ? new Path(config.getString(DRILL_EXEC_SYS_STORE_PROVIDER_ZK_BLOBROOT)) : LocalPersistentStore.getLogDir();
        try {
            this.fs = LocalPersistentStore.getFileSystem(config, this.blobRoot);
        }
        catch (IOException ex) {
            throw new StoreException("unable to get filesystem", ex);
        }
    }

    @Override
    public <V> PersistentStore<V> getOrCreateStore(PersistentStoreConfig<V> config) throws StoreException {
        switch (config.getMode()) {
            case BLOB_PERSISTENT: {
                return new LocalPersistentStore<V>(this.fs, this.blobRoot, config);
            }
            case PERSISTENT: {
                ZookeeperPersistentStore<V> store = new ZookeeperPersistentStore<V>(this.curator, config);
                try {
                    store.start();
                }
                catch (Exception e) {
                    throw new StoreException("unable to start zookeeper store", e);
                }
                return store;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public <V> VersionedPersistentStore<V> getOrCreateVersionedStore(PersistentStoreConfig<V> config) throws StoreException {
        switch (config.getMode()) {
            case BLOB_PERSISTENT: {
                return new VersionedDelegatingStore<V>(new LocalPersistentStore<V>(this.fs, this.blobRoot, config));
            }
            case PERSISTENT: {
                ZookeeperPersistentStore<V> store = new ZookeeperPersistentStore<V>(this.curator, config);
                try {
                    store.start();
                }
                catch (Exception e) {
                    throw new StoreException("unable to start zookeeper store", e);
                }
                return store;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void close() throws Exception {
        this.fs.close();
    }
}

