/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.table.function;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.drill.exec.store.table.function.TableParamDef;

public final class TableSignature {
    private final String name;
    private final List<TableParamDef> commonParams;
    private final List<TableParamDef> specificParams;
    private final List<TableParamDef> params;

    public static TableSignature of(String name) {
        return new TableSignature(name, Collections.emptyList(), Collections.emptyList());
    }

    public static TableSignature of(String name, List<TableParamDef> commonParams) {
        return new TableSignature(name, commonParams, Collections.emptyList());
    }

    public static TableSignature of(String name, List<TableParamDef> commonParams, List<TableParamDef> specificParams) {
        return new TableSignature(name, commonParams, specificParams);
    }

    private TableSignature(String name, List<TableParamDef> commonParams, List<TableParamDef> specificParams) {
        this.name = name;
        this.commonParams = Collections.unmodifiableList(commonParams);
        this.specificParams = Collections.unmodifiableList(specificParams);
        this.params = Stream.of(specificParams, commonParams).flatMap(Collection::stream).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public String getName() {
        return this.name;
    }

    public List<TableParamDef> getParams() {
        return this.params;
    }

    public List<TableParamDef> getCommonParams() {
        return this.commonParams;
    }

    public List<TableParamDef> getSpecificParams() {
        return this.specificParams;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableSignature that = (TableSignature)o;
        return this.name.equals(that.name) && this.params.equals(that.params);
    }

    public String toString() {
        return "TableSignature{name='" + this.name + '\'' + ", commonParams=" + this.commonParams + ", specificParams=" + this.specificParams + '}';
    }
}

