/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.table.function;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.store.table.function.TableParamDef;
import org.apache.drill.exec.store.table.function.TableSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WithOptionsTableMacro
implements TableMacro {
    private static final Logger logger = LoggerFactory.getLogger(WithOptionsTableMacro.class);
    private final TableSignature sig;
    private final Function<List<Object>, DrillTable> function;

    public WithOptionsTableMacro(TableSignature sig, Function<List<Object>, DrillTable> function) {
        this.sig = sig;
        this.function = function;
    }

    public TranslatableTable apply(List<?> arguments) {
        DrillTable drillTable = this.function.apply(arguments);
        if (drillTable == null) {
            throw UserException.validationError().message("Unable to find table [%s]", this.sig.getName()).build(logger);
        }
        return drillTable;
    }

    public List<FunctionParameter> getParameters() {
        ArrayList<FunctionParameter> result = new ArrayList<FunctionParameter>();
        int i = 0;
        while (i < this.sig.getParams().size()) {
            final TableParamDef p = this.sig.getParams().get(i);
            final int ordinal = i++;
            FunctionParameter functionParameter = new FunctionParameter(){

                public int getOrdinal() {
                    return ordinal;
                }

                public String getName() {
                    return p.getName();
                }

                public RelDataType getType(RelDataTypeFactory typeFactory) {
                    return typeFactory.createJavaType(p.getType());
                }

                public boolean isOptional() {
                    return p.isOptional();
                }
            };
            result.add(functionParameter);
        }
        return result;
    }
}

