/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.testing;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.concurrent.ExtendedLatch;
import org.apache.drill.exec.testing.Injection;
import org.apache.drill.exec.testing.InjectionConfigurationException;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class PauseInjection
extends Injection {
    private final ExtendedLatch latch = new ExtendedLatch(1);

    @JsonCreator
    private PauseInjection(@JsonProperty(value="address") String address, @JsonProperty(value="port") int port, @JsonProperty(value="siteClass") String siteClass, @JsonProperty(value="desc") String desc, @JsonProperty(value="nSkip") int nSkip, @JsonProperty(value="msPause") long msPause) throws InjectionConfigurationException {
        super(address, port, siteClass, desc, nSkip, 1, msPause);
    }

    public void pause() {
        if (!this.injectNow()) {
            return;
        }
        if (this.getMsPause() > 0L) {
            try {
                this.latch.await(this.getMsPause(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                this.unpause();
            }
        } else {
            this.latch.awaitUninterruptibly();
        }
    }

    public void interruptiblePause() throws InterruptedException {
        if (!this.injectNow()) {
            return;
        }
        this.latch.await();
    }

    public void unpause() {
        this.latch.countDown();
    }
}

