/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.util;

import io.netty.buffer.DrillBuf;
import org.apache.drill.common.util.DrillStringUtils;

public class ByteBufUtil {
    public static void checkBufferLength(DrillBuf buffer, int start, int end, int requiredLen) {
        int actualLen = end - start;
        if (actualLen != requiredLen) {
            throw new IllegalArgumentException(String.format("Wrong length %d(%d-%d) in the buffer '%s', expected %d.", actualLen, end, start, DrillStringUtils.toBinaryString(buffer, start, end), requiredLen));
        }
    }

    public static class HadoopWritables {
        public static void writeVInt(DrillBuf buffer, int start, int end, int i) {
            HadoopWritables.writeVLong(buffer, start, end, i);
        }

        public static void writeVLong(DrillBuf buffer, int start, int end, long i) {
            int availableBytes = end - start;
            if (availableBytes < HadoopWritables.getVIntSize(i)) {
                throw new NumberFormatException("Expected " + HadoopWritables.getVIntSize(i) + " bytes but the buffer '" + DrillStringUtils.toBinaryString(buffer, start, end) + "' has only " + availableBytes + " bytes.");
            }
            buffer.writerIndex(start);
            if (i >= -112L && i <= 127L) {
                buffer.writeByte((byte)i);
                return;
            }
            int len = -112;
            if (i < 0L) {
                i ^= 0xFFFFFFFFFFFFFFFFL;
                len = -120;
            }
            long tmp = i;
            while (tmp != 0L) {
                tmp >>= 8;
                --len;
            }
            buffer.writeByte((byte)len);
            for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
                int shiftbits = (idx - 1) * 8;
                long mask = 255L << shiftbits;
                buffer.writeByte((byte)((i & mask) >> shiftbits));
            }
        }

        public static int readVInt(DrillBuf buffer, int start, int end) {
            long n = HadoopWritables.readVLong(buffer, start, end);
            if (n > Integer.MAX_VALUE || n < Integer.MIN_VALUE) {
                throw new NumberFormatException("Value " + n + " too long to fit in integer");
            }
            return (int)n;
        }

        public static long readVLong(DrillBuf buffer, int start, int end) {
            buffer.readerIndex(start);
            byte firstByte = buffer.readByte();
            int len = HadoopWritables.decodeVIntSize(firstByte);
            int availableBytes = end - start;
            if (len == 1) {
                return firstByte;
            }
            if (availableBytes < len) {
                throw new NumberFormatException("Expected " + len + " bytes but the buffer '" + DrillStringUtils.toBinaryString(buffer, start, end) + "' has  " + availableBytes + " bytes.");
            }
            long longValue = 0L;
            for (int idx = 0; idx < len - 1; ++idx) {
                byte byteValue = buffer.readByte();
                longValue <<= 8;
                longValue |= (long)(byteValue & 0xFF);
            }
            return HadoopWritables.isNegativeVInt(firstByte) ? longValue ^ 0xFFFFFFFFFFFFFFFFL : longValue;
        }

        public static int decodeVIntSize(byte value) {
            if (value >= -112) {
                return 1;
            }
            if (value < -120) {
                return -119 - value;
            }
            return -111 - value;
        }

        public static int getVIntSize(long i) {
            if (i >= -112L && i <= 127L) {
                return 1;
            }
            if (i < 0L) {
                i ^= 0xFFFFFFFFFFFFFFFFL;
            }
            int dataBits = 64 - Long.numberOfLeadingZeros(i);
            return (dataBits + 7) / 8 + 1;
        }

        public static boolean isNegativeVInt(byte value) {
            return value < -120 || value >= -112 && value < 0;
        }
    }
}

