/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class SerializationModule {
    public static final DateTimeFormatter formatDate = DateTimeFormatter.ofPattern("uuuu-MM-dd").withZone(ZoneOffset.UTC);
    public static final DateTimeFormatter formatTimeStamp = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSS").withZone(ZoneOffset.UTC);
    public static final DateTimeFormatter formatTime = DateTimeFormatter.ofPattern("HH:mm:ss.SSS").withZone(ZoneOffset.UTC);
    public static final SimpleModule drillModule = new SimpleModule("DrillModule");

    public static final SimpleModule getModule() {
        return drillModule;
    }

    static {
        drillModule.addSerializer(LocalTime.class, (JsonSerializer)new JsonSerializer<LocalTime>(){

            public void serialize(LocalTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                gen.writeString(formatTime.format(value));
            }
        });
        drillModule.addSerializer(LocalDate.class, (JsonSerializer)new JsonSerializer<LocalDate>(){

            public void serialize(LocalDate value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                gen.writeString(formatDate.format(value));
            }
        });
        drillModule.addSerializer(LocalDateTime.class, (JsonSerializer)new JsonSerializer<LocalDateTime>(){

            public void serialize(LocalDateTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                gen.writeString(formatTimeStamp.format(value));
            }
        });
    }
}

