/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import io.netty.buffer.DrillBuf;
import java.util.Collections;
import java.util.Iterator;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.UInt1Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public abstract class BaseValueVector
implements ValueVector {
    @Deprecated
    public static final int MAX_ALLOCATION_SIZE = Integer.MAX_VALUE;
    public static final int INITIAL_VALUE_ALLOCATION = 4096;
    protected final BufferAllocator allocator;
    protected final MaterializedField field;

    protected BaseValueVector(MaterializedField field, BufferAllocator allocator) {
        this.field = Preconditions.checkNotNull(field, "field cannot be null");
        this.allocator = Preconditions.checkNotNull(allocator, "allocator cannot be null");
    }

    public String toString() {
        return super.toString() + "[field = " + this.field + ", ...]";
    }

    @Override
    public void clear() {
        this.getMutator().reset();
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public MaterializedField getField() {
        return this.field;
    }

    public MaterializedField getField(String ref) {
        return this.getField().withPath(ref);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return this.getTransferPair(this.getField().getName(), allocator);
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().build();
    }

    protected UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return this.getField().getAsBuilder().setValueCount(this.getAccessor().getValueCount()).setBufferLength(this.getBufferSize());
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return Collections.emptyIterator();
    }

    public static boolean checkBufRefs(ValueVector vv) {
        for (DrillBuf buffer : vv.getBuffers(false)) {
            if (buffer.refCnt() > 0) continue;
            throw new IllegalStateException("zero refcount");
        }
        return true;
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    public static void fillBitsVector(UInt1Vector bits, int valueCount) {
        bits.allocateNew(valueCount);
        UInt1Vector.Mutator bitsMutator = bits.getMutator();
        for (int i = 0; i < valueCount; ++i) {
            bitsMutator.set(i, 1);
        }
        bitsMutator.setValueCount(valueCount);
    }

    @Override
    public void toNullable(ValueVector nullableVector) {
        throw new UnsupportedOperationException();
    }

    public static abstract class BaseMutator
    implements ValueVector.Mutator {
        protected BaseMutator() {
        }

        @Override
        public void generateTestData(int values) {
        }

        @Override
        public void reset() {
        }

        @Override
        public void exchange(ValueVector.Mutator other) {
        }
    }

    public static abstract class BaseAccessor
    implements ValueVector.Accessor {
        protected BaseAccessor() {
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }
    }
}

