/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import java.util.List;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import org.apache.drill.exec.expr.holders.RepeatedTinyIntHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.drill.exec.vector.AddOrGetResult;
import org.apache.drill.exec.vector.TinyIntVector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VectorDescriptor;
import org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import org.apache.drill.exec.vector.complex.RepeatedFixedWidthVectorLike;
import org.apache.drill.exec.vector.complex.RepeatedValueVector;
import org.apache.drill.exec.vector.complex.impl.RepeatedTinyIntReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedTinyIntVector
extends BaseRepeatedValueVector
implements RepeatedFixedWidthVectorLike {
    private TinyIntVector values;
    private final FieldReader reader = new RepeatedTinyIntReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedTinyIntVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        TypeProtos.MajorType majorType = field.getType();
        this.addOrGetVector(VectorDescriptor.create(Types.withPrecisionAndScale(majorType.getMinorType(), TypeProtos.DataMode.REQUIRED, majorType.getPrecision(), majorType.getScale())));
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public TinyIntVector getDataVector() {
        return this.values;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedTinyIntVector)to);
    }

    public AddOrGetResult<TinyIntVector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult<TinyIntVector> result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedTinyIntVector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedTinyIntVector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedTinyIntVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
        this.mutator.setValueCount(outIndex + 1);
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedTinyIntVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
        this.mutator.setValueCount(outIndex + 1);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (RepeatedTinyIntVector)from);
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    public void allocateNew(int valueCount, int innerValueCount) {
        this.clear();
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(innerValueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
            super(RepeatedTinyIntVector.this);
        }

        public void add(int index, int value) {
            int nextOffset = RepeatedTinyIntVector.this.offsets.getAccessor().get(index + 1);
            RepeatedTinyIntVector.this.values.getMutator().set(nextOffset, value);
            RepeatedTinyIntVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, byte srcValue) {
            int nextOffset = RepeatedTinyIntVector.this.offsets.getAccessor().get(index + 1);
            RepeatedTinyIntVector.this.values.getMutator().setSafe(nextOffset, srcValue);
            RepeatedTinyIntVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedTinyIntHolder h) {
            TinyIntHolder ih = new TinyIntHolder();
            TinyIntVector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedTinyIntVector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedTinyIntVector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, TinyIntHolder holder) {
            int nextOffset = RepeatedTinyIntVector.this.offsets.getAccessor().get(index + 1);
            RepeatedTinyIntVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedTinyIntVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableTinyIntHolder holder) {
            int nextOffset = RepeatedTinyIntVector.this.offsets.getAccessor().get(index + 1);
            RepeatedTinyIntVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedTinyIntVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void fillEmpties(int lastWrite, int index) {
            int fillOffset = RepeatedTinyIntVector.this.offsets.getAccessor().get(lastWrite + 1);
            UInt4Vector.Mutator offsetMutator = RepeatedTinyIntVector.this.offsets.getMutator();
            for (int i = lastWrite; i < index; ++i) {
                offsetMutator.setSafe(i + 1, fillOffset);
            }
        }

        protected void add(int index, TinyIntHolder holder) {
            int nextOffset = RepeatedTinyIntVector.this.offsets.getAccessor().get(index + 1);
            RepeatedTinyIntVector.this.values.getMutator().set(nextOffset, holder);
            RepeatedTinyIntVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedTinyIntHolder holder) {
            TinyIntVector.Accessor accessor = holder.vector.getAccessor();
            TinyIntHolder innerHolder = new TinyIntHolder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        @Override
        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedTinyIntVector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedTinyIntVector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        @Override
        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        public Accessor() {
            super(RepeatedTinyIntVector.this);
        }

        @Override
        public List<Byte> getObject(int index) {
            JsonStringArrayList<Byte> vals = new JsonStringArrayList<Byte>();
            UInt4Vector.Accessor offsetsAccessor = RepeatedTinyIntVector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            TinyIntVector.Accessor valuesAccessor = RepeatedTinyIntVector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public Byte getSingleObject(int index, int arrayIndex) {
            int start = RepeatedTinyIntVector.this.offsets.getAccessor().get(index);
            return RepeatedTinyIntVector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public byte get(int index, int positionIndex) {
            return RepeatedTinyIntVector.this.values.getAccessor().get(RepeatedTinyIntVector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedTinyIntHolder holder) {
            holder.start = RepeatedTinyIntVector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedTinyIntVector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedTinyIntVector.this.values;
            holder.reader = RepeatedTinyIntVector.this.reader;
        }

        public void get(int index, int positionIndex, TinyIntHolder holder) {
            int offset = RepeatedTinyIntVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedTinyIntVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableTinyIntHolder holder) {
            int offset = RepeatedTinyIntVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedTinyIntVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedTinyIntVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new RepeatedTinyIntVector(field, allocator);
        }

        public TransferImpl(RepeatedTinyIntVector to) {
            this.to = to;
        }

        @Override
        public RepeatedTinyIntVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedTinyIntVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            RepeatedTinyIntVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedTinyIntVector.this);
        }
    }
}

