/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import java.util.List;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import org.apache.drill.exec.expr.holders.RepeatedVarDecimalHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.drill.exec.vector.AddOrGetResult;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarDecimalVector;
import org.apache.drill.exec.vector.VectorDescriptor;
import org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import org.apache.drill.exec.vector.complex.RepeatedValueVector;
import org.apache.drill.exec.vector.complex.RepeatedVariableWidthVectorLike;
import org.apache.drill.exec.vector.complex.impl.RepeatedVarDecimalReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedVarDecimalVector
extends BaseRepeatedValueVector
implements RepeatedVariableWidthVectorLike {
    private VarDecimalVector values;
    private final FieldReader reader = new RepeatedVarDecimalReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedVarDecimalVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        TypeProtos.MajorType majorType = field.getType();
        this.addOrGetVector(VectorDescriptor.create(Types.withPrecisionAndScale(majorType.getMinorType(), TypeProtos.DataMode.REQUIRED, majorType.getPrecision(), majorType.getScale())));
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public VarDecimalVector getDataVector() {
        return this.values;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedVarDecimalVector)to);
    }

    public AddOrGetResult<VarDecimalVector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult<VarDecimalVector> result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedVarDecimalVector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedVarDecimalVector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedVarDecimalVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
        this.mutator.setValueCount(outIndex + 1);
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedVarDecimalVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
        this.mutator.setValueCount(outIndex + 1);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (RepeatedVarDecimalVector)from);
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    protected UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return super.getMetadataBuilder().setVarByteLength(this.values.getCurrentSizeInBytes());
    }

    @Override
    public void allocateNew(int totalBytes, int valueCount, int innerValueCount) {
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(totalBytes, innerValueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    public int getByteCapacity() {
        return this.values.getByteCapacity();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
            super(RepeatedVarDecimalVector.this);
        }

        public void add(int index, byte[] value) {
            int nextOffset = RepeatedVarDecimalVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVarDecimalVector.this.values.getMutator().set(nextOffset, value);
            RepeatedVarDecimalVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, byte[] bytes) {
            this.addSafe(index, bytes, 0, bytes.length);
        }

        public void addSafe(int index, byte[] bytes, int start, int length) {
            int nextOffset = RepeatedVarDecimalVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVarDecimalVector.this.values.getMutator().setSafe(nextOffset, bytes, start, length);
            RepeatedVarDecimalVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedVarDecimalHolder h) {
            VarDecimalHolder ih = new VarDecimalHolder();
            VarDecimalVector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedVarDecimalVector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedVarDecimalVector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, VarDecimalHolder holder) {
            int nextOffset = RepeatedVarDecimalVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVarDecimalVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedVarDecimalVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableVarDecimalHolder holder) {
            int nextOffset = RepeatedVarDecimalVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVarDecimalVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedVarDecimalVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void fillEmpties(int lastWrite, int index) {
            int fillOffset = RepeatedVarDecimalVector.this.offsets.getAccessor().get(lastWrite + 1);
            UInt4Vector.Mutator offsetMutator = RepeatedVarDecimalVector.this.offsets.getMutator();
            for (int i = lastWrite; i < index; ++i) {
                offsetMutator.setSafe(i + 1, fillOffset);
            }
        }

        public void addSafe(int rowIndex, int start, int end, DrillBuf buffer) {
            int nextOffset = RepeatedVarDecimalVector.this.offsets.getAccessor().get(rowIndex + 1);
            RepeatedVarDecimalVector.this.values.getMutator().setSafe(nextOffset, start, end, buffer);
            RepeatedVarDecimalVector.this.offsets.getMutator().setSafe(rowIndex + 1, nextOffset + 1);
        }

        protected void add(int index, VarDecimalHolder holder) {
            int nextOffset = RepeatedVarDecimalVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVarDecimalVector.this.values.getMutator().set(nextOffset, holder);
            RepeatedVarDecimalVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedVarDecimalHolder holder) {
            VarDecimalVector.Accessor accessor = holder.vector.getAccessor();
            VarDecimalHolder innerHolder = new VarDecimalHolder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        @Override
        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedVarDecimalVector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedVarDecimalVector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        @Override
        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        public Accessor() {
            super(RepeatedVarDecimalVector.this);
        }

        @Override
        public List<BigDecimal> getObject(int index) {
            JsonStringArrayList<BigDecimal> vals = new JsonStringArrayList<BigDecimal>();
            UInt4Vector.Accessor offsetsAccessor = RepeatedVarDecimalVector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            VarDecimalVector.Accessor valuesAccessor = RepeatedVarDecimalVector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public BigDecimal getSingleObject(int index, int arrayIndex) {
            int start = RepeatedVarDecimalVector.this.offsets.getAccessor().get(index);
            return RepeatedVarDecimalVector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public byte[] get(int index, int positionIndex) {
            return RepeatedVarDecimalVector.this.values.getAccessor().get(RepeatedVarDecimalVector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedVarDecimalHolder holder) {
            holder.start = RepeatedVarDecimalVector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedVarDecimalVector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedVarDecimalVector.this.values;
            holder.reader = RepeatedVarDecimalVector.this.reader;
        }

        public void get(int index, int positionIndex, VarDecimalHolder holder) {
            int offset = RepeatedVarDecimalVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedVarDecimalVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableVarDecimalHolder holder) {
            int offset = RepeatedVarDecimalVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedVarDecimalVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedVarDecimalVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new RepeatedVarDecimalVector(field, allocator);
        }

        public TransferImpl(RepeatedVarDecimalVector to) {
            this.to = to;
        }

        @Override
        public RepeatedVarDecimalVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedVarDecimalVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            RepeatedVarDecimalVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedVarDecimalVector.this);
        }
    }
}

