/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.ValueVector;

public class VectorValidator {
    public static void validate(RecordBatch batch) {
        int count = batch.getRecordCount();
        long hash = 12345L;
        BatchSchema.SelectionVectorMode mode = batch.getSchema().getSelectionVectorMode();
        switch (mode) {
            case NONE: {
                for (VectorWrapper w : batch) {
                    Object v = w.getValueVector();
                    for (int i = 0; i < count; ++i) {
                        Object obj = v.getAccessor().getObject(i);
                        if (obj == null) continue;
                        hash = (long)obj.hashCode() ^ hash;
                    }
                }
                break;
            }
            case TWO_BYTE: {
                for (VectorWrapper w : batch) {
                    Object v = w.getValueVector();
                    for (int i = 0; i < count; ++i) {
                        char index = batch.getSelectionVector2().getIndex(i);
                        Object obj = v.getAccessor().getObject(index);
                        if (obj == null) continue;
                        hash = (long)obj.hashCode() ^ hash;
                    }
                }
                break;
            }
            case FOUR_BYTE: {
                for (VectorWrapper w : batch) {
                    ValueVector[] vv = w.getValueVectors();
                    for (int i = 0; i < count; ++i) {
                        int index = batch.getSelectionVector4().get(i);
                        ValueVector v = vv[index >> 16];
                        Object obj = v.getAccessor().getObject(index & 0xFFFF);
                        if (obj == null) continue;
                        hash = (long)obj.hashCode() ^ hash;
                    }
                }
                break;
            }
        }
        if (hash == 0L) {
            // empty if block
        }
    }
}

