/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import io.netty.buffer.DrillBuf;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.memory.AllocationManager;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.impl.NullReader;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public class ZeroVector
implements ValueVector {
    public static final ZeroVector INSTANCE = new ZeroVector();
    private final MaterializedField field = MaterializedField.create("[DEFAULT]", Types.LATE_BIND_TYPE);
    private final TransferPair defaultPair = new TransferPair(){

        @Override
        public void transfer() {
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
        }

        @Override
        public ValueVector getTo() {
            return ZeroVector.this;
        }

        @Override
        public void copyValueSafe(int from, int to) {
        }
    };
    private final ValueVector.Accessor defaultAccessor = new ValueVector.Accessor(){

        @Override
        public Object getObject(int index) {
            return null;
        }

        @Override
        public int getValueCount() {
            return 0;
        }

        @Override
        public boolean isNull(int index) {
            return true;
        }
    };
    private final ValueVector.Mutator defaultMutator = new ValueVector.Mutator(){

        @Override
        public void setValueCount(int valueCount) {
        }

        @Override
        public void reset() {
        }

        @Override
        public void generateTestData(int values) {
        }

        @Override
        public void exchange(ValueVector.Mutator other) {
        }
    };

    @Override
    public void close() {
    }

    @Override
    public void clear() {
    }

    @Override
    public MaterializedField getField() {
        return this.field;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return this.defaultPair;
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getField().getAsBuilder().setBufferLength(this.getBufferSize()).setValueCount(this.getAccessor().getValueCount()).build();
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public int getBufferSize() {
        return 0;
    }

    @Override
    public int getAllocatedSize() {
        return 0;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        return 0;
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        return new DrillBuf[0];
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        this.allocateNewSafe();
    }

    @Override
    public boolean allocateNewSafe() {
        return true;
    }

    @Override
    public BufferAllocator getAllocator() {
        throw new UnsupportedOperationException("Tried to get allocator from ZeroVector");
    }

    @Override
    public void setInitialCapacity(int numRecords) {
    }

    @Override
    public int getValueCapacity() {
        return 0;
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return this.defaultPair;
    }

    @Override
    public TransferPair makeTransferPair(ValueVector target) {
        return this.defaultPair;
    }

    @Override
    public ValueVector.Accessor getAccessor() {
        return this.defaultAccessor;
    }

    @Override
    public ValueVector.Mutator getMutator() {
        return this.defaultMutator;
    }

    @Override
    public FieldReader getReader() {
        return NullReader.INSTANCE;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
    }

    @Override
    public void exchange(ValueVector other) {
    }

    @Override
    public void collectLedgers(Set<AllocationManager.BufferLedger> ledgers) {
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return 0;
    }

    @Override
    public void toNullable(ValueVector nullableVector) {
        throw new UnsupportedOperationException();
    }
}

