/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor;

import java.sql.Date;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.vector.DateVector;
import org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

public class DateAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.required(TypeProtos.MinorType.DATE);
    private final DateVector.Accessor ac;

    public DateAccessor(DateVector vector) {
        this.ac = vector.getAccessor();
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return false;
    }

    @Override
    public Class<?> getObjectClass() {
        return Date.class;
    }

    @Override
    public Object getObject(int index) {
        return this.getDate(index);
    }

    @Override
    public Date getDate(int index) {
        LocalDate date = new LocalDate(this.ac.get(index), DateTimeZone.UTC);
        return new Date(date.toDate().getTime());
    }
}

