/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor;

import java.sql.Date;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.vector.NullableDateVector;
import org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

public class NullableDateAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional(TypeProtos.MinorType.DATE);
    private final NullableDateVector.Accessor ac;

    public NullableDateAccessor(NullableDateVector vector) {
        this.ac = vector.getAccessor();
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    @Override
    public Class<?> getObjectClass() {
        return Date.class;
    }

    @Override
    public Object getObject(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.getDate(index);
    }

    @Override
    public Date getDate(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        LocalDate date = new LocalDate(this.ac.get(index), DateTimeZone.UTC);
        return new Date(date.toDate().getTime());
    }
}

