/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor;

import java.sql.Timestamp;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.vector.NullableTimeStampVector;
import org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

public class NullableTimeStampAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional(TypeProtos.MinorType.TIMESTAMP);
    private final NullableTimeStampVector.Accessor ac;

    public NullableTimeStampAccessor(NullableTimeStampVector vector) {
        this.ac = vector.getAccessor();
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    @Override
    public Class<?> getObjectClass() {
        return Timestamp.class;
    }

    @Override
    public Object getObject(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.getTimestamp(index);
    }

    @Override
    public Timestamp getTimestamp(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        LocalDateTime dateTime = new LocalDateTime(this.ac.get(index), DateTimeZone.UTC);
        return new Timestamp(dateTime.toDate().getTime());
    }
}

